## 模块化

可以将一些公共的代码抽离成为一个单独的 js 文件，作为一个模块，使用时再引入。

模块可以通过 [`module.exports`](../../reference/api/module.html) 或者 `exports` 对外暴露接口，通过 `require` 引入模块。

### require

`require` 引入模块推荐使用静态引入的方式，即路径参数是字符串字面量，不推荐路径参数中带有变量或者运算逻辑。

静态引入模块的代码，在编译阶段将得到尽可能大的优化，构建工具仅打包引用到的文件，提高运行时的执行效率。

如果想动态 `require` 模块，需要注意：**动态 require 需要指明路径前缀**

```javascript
// 推荐静态引入
require('./utils/foo')
// 支持带路径前缀的动态引入方式
require('./utils' + subpath)

// 以下写法均不支持
require('' + modPath)
require(modPath)
```

代码示例：

```js
const mods = [
  {
    name: 'foo',
    path: './foo.js'
  },
  {
    name: 'bar',
    path: './bar.js'
  }
]
let exports = {}
for (let mod in mods) {
  exports[mods[mod].name] = require('./utils/' + mods[mod].path)
}
```
