# 注册快应用

框架提供了 `App` 方法用于快应用注册。每个快应用都需要在 `app.js` 中调用一次 `App` 方法注册，并且仅能调用一次。`App` 方法中可以绑定生命周期回调函数，添加错误监听和自定义数据、方法等。

详情参考 [App 文档](../../reference/api/App.html) 。

```js
// app.js
App({
  onLaunch(options) {
    // 快应用加载完时触发
  },
  onShow(options) {
    // 显示时触发
  },
  onHide() {
    // 隐藏时触发
  },
  onError(msg) {
    console.log(msg)
  },
  globalData: 'global data'
})
```

整个快应用共享同一个 App 实例。开发者可以通过 `getApp` 方法获取到全局唯一的 App 实例。

```js
// xxx.js
const app = getApp()
console.log(app.globalData) // global data
```
