## 应用资源

文件组织结构

```bash
├── app.json
├── app.js
├── pages
│   ├── page1
│   │   ├── page1.qxml
│   │   ├── page1.css
│   │   ├── page1.json
│   │   └── page1.js
│   └── page2
│       ├── page2.qxml
│       ├── page2.css
│       ├── page2.json
│       └── page2.js
├── sign
│   ├── debug
│   │   ├── certificate.pem
│   │   └── private.pem
│   └── release
│       ├── certificate.pem
│       └── private.pem
└── project.config.json
```

以上的其中 `pages` 仅是推荐写法，无特殊限制

## 文件存储

在应用平台中是按分区来存储文件的，目前支持以下分区

1. Cache，一般用于存储缓存文件，比如通过 fetch 接口下载的文件会存储在该分区中，该分区中的文件可能因存储空间不够被系统删除
2. Files，一般用于存储比较小的永久文件，该分区中的文件由应用自己管理
3. Mass，一般用于存储比较大的文件，但该分区并不保证一直可用
4. Temp，表示从外部映射过来的临时文件，出于安全性考虑，临时文件是只读的，并且只能通过调用特定的 API 获取，比如 media.pickVideo 方法。另外临时文件的访问是临时的，应用重启后无法访问到临时文件，需要通过特定 API 重新获取。

另外应用资源也作为一个特殊的只读分区进行处理。

## URI

URI 用于标识应用资源和文件。

| 资源类型 | URI                   | 只读 | 示例                              | 说明                             |
| -------- | --------------------- | ---- | --------------------------------- | -------------------------------- |
| 应用资源 | /path                 | 是   | /Common/header.png                | -                                |
| Cache    | internal://cache/path | 否   | internal://cache/fetch-123456.png | -                                |
| Files    | internal://files/path | 否   | internal://files/image/demo.png   | -                                |
| Mass     | internal://mass/path  | 否   | internal://mass/video/demo.mp4    | qa.saveFile 保存为 Mass 资源类型 |
| Temp     | internal://tmp/path   | 是   | internal://tmp/xxxxx              | 由系统动态生成                   |

URI 允许的字符是`0-9a-zA-Z_-./%:`(不包含引号)，URI 中不能出现`..`，URI 支持目录结构，目录由斜线'/'分隔。

internal URI 表示的是应用私有文件，即在指定 internal URI 时，无需指定应用标识，同一个 internal URI 对于不同的应用会指向不同的文件。

## `qa.env.USER_DATA_PATH`

在开发过程中，为了方便，可以直接使用此路径用于表示用户存储区，该区域位于 Mass 分区下。

## 资源和文件访问规则

应用资源路径分为绝对路径和相对路径，以"/"开头的路径表示绝对路径，比如 /Common/a.png，不以"/"开头的路径是相对路径，比如 a.png 和 ../Common/a.png 等。

应用资源文件分为代码文件和资源文件，代码文件是指 .js/.css/.ux 等包含代码的文件，其他文件则是资源文件，这类文件一般只当作数据来使用，比如图片、视频等。
