# web-view

承载网页的容器。此组件会自动铺满整个快应用页面，且每个页面最多只能有一个。

| 属性 | 类型 | <div style="width: 50px">默认值 </div> | <div style="width: 50px">必填 </div> | 说明 |
| --- | --- | --- | --- | --- |
| src | string |  | 否 | webview 指向网页的链接；可以通过 `qa.setTrustedUrls` 方法为业务，设定可信任网址。 |
| enable-jssdk | boolean | `false` | 否 | 是否注入 `JSSDK`，使得网页可以调用所提供的 API。 |
| bindload | eventhandler |  | 否 | 网页加载成功时候触发此事件。e.detail = { src } |
| binderror | eventhandler |  | 否 | 网页加载失败的时候触发此事件。e.detail = { src } |
| bindmessage | eventhandler |  | 否 | 网页通过 postMessage 方法向快应用发送消息，会在特定时机（如：快应用后退、组件销毁）触发并收到。e.detail = { data }，data 是多次 postMessage 的参数组成的数组 |

默认情形下，`src` 属性所指向网页的链接，是可以信任的；为安全考量，其他网页如果想调用 `JSSDK` 中提供的 API，须通过 `qa.setTrustedUrls` 方法，配置可信任的网址（支持正则表达式），示例如下：

```js
// app.js
qa.setTrustedUrls([
  'https://your-domain-name.cn/explore/',
  /^https?:\/\/your-domain-name.com/,
  /^https?:\/\/(www\.)your-domain-name.com/,
  /^https?:\/\/([a-z0-9]*\.)your-domain-name.com/
])
```

## 相关接口

`web-view` 网页中可使用内置 `JSSDK` 提供的接口，返回快应用页面（需要通过 `enable-jssdk` 手动开启）。 现支持的有以下接口：

| 接口名          | 说明                                                                          |
| :-------------- | :---------------------------------------------------------------------------- |
| qa.navigateTo   | 参数与快应用接口一致                                                          |
| qa.navigateBack | 参数与快应用接口一致                                                          |
| qa.switchTab    | 参数与快应用接口一致                                                          |
| qa.reLaunch     | 参数与快应用接口一致                                                          |
| qa.redirectTo   | 参数与快应用接口一致                                                          |
| qa.postMessage  | 向快应用发送消息，会在特定时机（快应用后退、组件销毁）触发组件的 Message 事件 |
| qa.getEnv       | 获取当前环境                                                                  |

## 示例代码

```js
// JavaScript Code
qa.navigateTo({ url: '/path/to/page' })

qa.navigateBack({
  delta: 1,
  success: res => {
    // 做些你需要处理的事情
  }
})

qa.postMessage({ data: 'QuickApp' })
qa.postMessage({ data: { foo: 'QuickApp' } })
```

在网页内可通过 `window.__qajs_environment` 变量，来判断是否在快应用环境；也可以在 `QaJSBridgeReady` 回调中使用，或者使用 `getEnv` 接口，还可以通过判断 userAgent 中，是否包含 `quickapp` 字样来判断。具体请参见如下示例：

```js
// web-view 下网页对应代码
function jSBridgeReady() {
  console.log(window.__qajs_environment === 'quickapp') // true
}
if (!window.QaJSBridge || !QaJSBridge.invoke) {
  document.addEventListener('QaJSBridgeReady', jSBridgeReady, false)
} else {
  jSBridgeReady()
}

// 或者在 getEnv 回调中处理
qa.getEnv(res => {
  console.log(res.quickapp) // true
})

// 或者基于 userAgent 判断
if (navigator.userAgent.includes('quickapp')) {
  // 做些你需要处理的事情
}
```

## Bug & Tip

::: warning

- 每个页面只能有一个 web-view，web-view 会自动铺满整个页面，并覆盖其他组件；
- 如果 `src` 所指定的网页，不能正常调用所提供的 API，请检查 `enable-jssdk` 是否设定为 true；
- 倘若跳转的网页，不能正常调用所提供的 API，请检查该网页是否在 `qa.setTrustedUrls` 所指定规则内；
- web-view 网页与快应用之间不支持除 JSSDK 提供的接口之外的通信；

:::
