# textarea

多行输入框。该组件是[原生组件](native-component.html)，使用时请注意相关限制。

| 属性 | 类型 | <div style="width: 50px">默认值 </div> | <div style="width: 50px">必填 </div> | 说明 |
| --- | --- | --- | --- | --- |
| value | string |  | 否 | 输入框的内容 |  |
| placeholder | string |  | 否 | 输入框为空时占位符 |  |
| placeholder-style | string |  | 否 | 指定 placeholder 的样式，目前仅支持 color,font-size 和 font-weight |  |
| placeholder-class | string | textarea-placeholder | 否 | 指定 placeholder 的样式类 |  |
| disabled | boolean | false | 否 | 是否禁用 |  |
| maxlength | number | 140 | 否 | 最大输入长度，设置为 -1 的时候不限制最大长度 |  |
| focus | boolean | false | 否 | 获取焦点 |  |
| auto-height | boolean | false | 否 | 是否自动增高，设置 auto-height 时，style.height 不生效 |  |
| cursor-spacing | number | 0 | 否 | 指定光标与键盘的距离。取`textarea`距离底部的距离和`cursor-spacing`指定的距离的最小值作为光标与键盘的距离 |  |
| cursor | number | \-1 | 否 | 指定 focus 时的光标位置 |  |
| show-confirm-bar | boolean | true | 否 | 是否显示键盘上方带有”完成“按钮那一栏 |  |
| selection-start | number | \-1 | 否 | 光标起始位置，自动聚集时有效，需与`selection-end`搭配使用 |  |
| selection-end | number | \-1 | 否 | 光标结束位置，自动聚集时有效，需与`selection-start`搭配使用 |  |
| adjust-position | boolean | true | 否 | 键盘弹起时，是否自动上推页面 |  |
| bindfocus | eventhandle |  | 否 | 输入框聚焦时触发，event.detail = {value: value} |  |
| bindblur | eventhandle |  | 否 | 输入框失去焦点时触发，event.detail = {value, cursor} |  |
| bindlinechange | eventhandle |  | 否 | 输入框行数变化时调用，event.detail = { lineCount} |  |
| bindinput | eventhandle |  | 否 | 当键盘输入时，触发 input 事件，event.detail = {value, cursor}，**bindinput 处理函数的返回值并不会反映到 textarea 上** |  |
| bindconfirm | eventhandle |  | 否 | 点击完成时， 触发 confirm 事件，event.detail = {value: value} |  |

## Bug & Tip

::: warning

- `textarea` 的 `blur` 事件会晚于页面上的 `tap` 事件，如果需要在 `button` 的点击事件获取 `textarea`，可以使用 `form` 的 `bindsubmit`。
- 不建议在多行文本上对用户的输入进行修改，所以 `textarea` 的 `bindinput` 处理函数并不会将返回值反映到 `textarea` 上。

:::

## 示例代码

```html
<view class="section">
  <textarea bindblur="bindTextAreaBlur" auto-height placeholder="自动变高" />
</view>
<view class="section">
  <textarea placeholder="placeholder颜色是红色的" placeholder-style="color:red;" />
</view>
<view class="section">
  <textarea placeholder="这是一个可以自动聚焦的textarea" auto-focus />
</view>
<view class="section">
  <textarea placeholder="这个只有在按钮点击的时候才聚焦" focus="{{focus}}" />
  <view class="btn-area">
    <button bindtap="bindButtonTap">使得输入框获取焦点</button>
  </view>
</view>
<view class="section">
  <form bindsubmit="bindFormSubmit">
    <textarea placeholder="form 中的 textarea" name="textarea" />
    <button form-type="submit">提交</button>
  </form>
</view>
```

```js
//textarea.js
Page({
  data: {
    height: 20,
    focus: false
  },
  bindButtonTap: function() {
    this.setData({
      focus: true
    })
  },
  bindTextAreaBlur: function(e) {
    console.log(e.detail.value)
  },
  bindFormSubmit: function(e) {
    console.log(e.detail.value.textarea)
  }
})
```
