# switch

开关选择器。

| 属性 | 类型 | <div style="width: 50px">默认值 </div> | <div style="width: 50px">必填 </div> | 说明 |
| --- | --- | --- | --- | --- |
| checked | boolean | false | 否 | 是否选中 |  |
| disabled | boolean | false | 否 | 是否禁用 |  |
| type | string | switch | 否 | 样式，有效值：switch, checkbox |  |
| color | string | #04BE02 | 否 | switch 的颜色，同 css 的 color |  |
| bindchange | eventhandle |  | 否 | checked 改变时触发 change 事件，event.detail={ value} |  |

## 示例代码

```html
<view class="body-view">
  <switch checked bindchange="switch1Change" />
  <switch bindchange="switch2Change" />
</view>
```

```js
Page({
  switch1Change: function(e) {
    console.log('switch1 发生 change 事件，携带值为', e.detail.value)
  },
  switch2Change: function(e) {
    console.log('switch2 发生 change 事件，携带值为', e.detail.value)
  }
})
```

![](data:image/png;base64,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)
