# slider

滑动选择器。

| 属性 | 类型 | <div style="width: 50px">默认值 </div> | <div style="width: 50px">必填 </div> | 说明 |
| --- | --- | --- | --- | --- |
| min | number | 0 | 否 | 最小值 |  |
| max | number | 100 | 否 | 最大值 |  |
| step | number | 1 | 否 | 步长，取值必须大于 0，并且可被(max - min)整除 |  |
| disabled | boolean | false | 否 | 是否禁用 |  |
| value | number | 0 | 否 | 当前取值 |  |
| active-color | color | #1aad19 | 否 | 已选择部分的颜色 |  |
| background-color | color | #e9e9e9 | 否 | 背景条的颜色 |  |
| block-size | number | 28 | 否 | 滑块的大小，取值范围为 12 - 28 |  |
| block-color | color | #ffffff | 否 | 滑块的颜色 |  |
| show-value | boolean | false | 否 | 是否显示当前 value |  |
| bindchange | eventhandle |  | 否 | 完成一次拖动后触发的事件，event.detail = {value} |  |
| bindchanging | eventhandle |  | 否 | 拖动过程中触发的事件，event.detail = {value} |  |

## 示例代码

```html
<view class="section section_gap">
  <text class="section__title">设置step</text>
  <view class="body-view">
    <slider bindchange="slider2change" step="5" />
  </view>
</view>

<view class="section section_gap">
  <text class="section__title">显示当前value</text>
  <view class="body-view">
    <slider bindchange="slider3change" show-value />
  </view>
</view>

<view class="section section_gap">
  <text class="section__title">设置最小/最大值</text>
  <view class="body-view">
    <slider bindchange="slider4change" min="50" max="200" show-value />
  </view>
</view>
```

```js
var pageData = {}
for (var i = 1; i < 5; i++) {
  ;(function(index) {
    pageData['slider' + index + 'change'] = function(e) {
      console.log('slider' + 'index' + '发生 change 事件，携带值为', e.detail.value)
    }
  })(i)
}
Page(pageData)
```

![](~@assets/slider.png)
