# rich-text

富文本。

| 属性  | 类型         | 默认值 | 必填 | 说明                 |
| ----- | ------------ | ------ | ---- | -------------------- |
| nodes | array/string | \[\]   | 否   | 节点列表/HTML String |
| space | string       |        | 否   | 显示连续空格         |

**space 的合法值**

| 值   | 说明                   |
| ---- | ---------------------- |
| ensp | 中文字符空格一半大小   |
| emsp | 中文字符空格大小       |
| nbsp | 根据字体设置的空格大小 |

## nodes

现支持两种节点，通过 type 来区分，分别是元素节点和文本节点，默认是元素节点，在富文本区域里显示的 HTML 节点 _元素节点：type = node_\*

| 属性     | 说明       | 类型   | 必填 | 备注                                     |
| -------- | ---------- | ------ | ---- | ---------------------------------------- |
| name     | 标签名     | string | 是   | 支持部分受信任的 HTML 节点               |
| attrs    | 属性       | object | 否   | 支持部分受信任的属性，遵循 Pascal 命名法 |
| children | 子节点列表 | array  | 否   | 结构和 nodes 一致                        |

_文本节点：type = text_\*

| 属性 | 说明 | 类型   | 必填 | 备注          |
| ---- | ---- | ------ | ---- | ------------- |
| text | 文本 | string | 是   | 支持 entities |

## 受信任的 HTML 节点及属性

全局支持 class 和 style 属性，**不支持 id 属性**。

| 节点       | 属性                            |
| ---------- | ------------------------------- |
| a          |                                 |
| abbr       |                                 |
| address    |                                 |
| article    |                                 |
| aside      |                                 |
| b          |                                 |
| bdi        |                                 |
| bdo        | dir                             |
| big        |                                 |
| blockquote |                                 |
| br         |                                 |
| caption    |                                 |
| center     |                                 |
| cite       |                                 |
| code       |                                 |
| col        | span，width                     |
| colgroup   | span，width                     |
| dd         |                                 |
| del        |                                 |
| div        |                                 |
| dl         |                                 |
| dt         |                                 |
| em         |                                 |
| fieldset   |                                 |
| font       |                                 |
| footer     |                                 |
| h1         |                                 |
| h2         |                                 |
| h3         |                                 |
| h4         |                                 |
| h5         |                                 |
| h6         |                                 |
| header     |                                 |
| hr         |                                 |
| i          |                                 |
| img        | alt，src，height，width         |
| ins        |                                 |
| label      |                                 |
| legend     |                                 |
| li         |                                 |
| mark       |                                 |
| nav        |                                 |
| ol         | start，type                     |
| p          |                                 |
| pre        |                                 |
| q          |                                 |
| rt         |                                 |
| ruby       |                                 |
| s          |                                 |
| section    |                                 |
| small      |                                 |
| span       |                                 |
| strong     |                                 |
| sub        |                                 |
| sup        |                                 |
| table      | width                           |
| tbody      |                                 |
| td         | colspan，height，rowspan，width |
| tfoot      |                                 |
| th         | colspan，height，rowspan，width |
| thead      |                                 |
| tr         | colspan，height，rowspan，width |
| tt         |                                 |
| u          |                                 |
| ul         |                                 |

## Bug & Tip

::: warning

- nodes 不推荐使用 String 类型，性能会有所下降。
- `rich-text` 组件内屏蔽所有节点的事件。
- attrs 属性不支持 id ，支持 class 。
- name 属性大小写不敏感。
- 如果使用了不受信任的 HTML 节点，该节点及其所有子节点将会被移除。
- img 标签仅支持网络图片。
- 如果在自定义组件中使用 `rich-text` 组件，那么仅自定义组件的 css 样式对 `rich-text` 中的 class 生效。

:::

## 示例代码

```html
<!-- qxml -->
<rich-text nodes="{{nodes}}" bindtap="tap"></rich-text>
```

```js
// js
Page({
  data: {
    nodes: [
      {
        name: 'div',
        attrs: {
          class: 'div_class',
          style: 'line-height: 60px; color: red;'
        },
        children: [
          {
            type: 'text',
            text: 'Hello&nbsp;World!'
          }
        ]
      }
    ]
  },
  tap() {
    console.log('tap')
  }
})
```
