# native-component

## 原生组件

快应用中的部分组件是由客户端创建的原生组件，这些组件有：

- [`cover-view`](cover-view.html)
- [`cover-image`](cover-image.html)
- [`canvas`](canvas.html)
- [`input`](input.html)（仅在 focus 时表现为原生组件）
- [`map`](map.html)
- [`textarea`](textarea.html)
- [`video`](video.html)

## 原生组件的使用限制

由于原生组件脱离在 WebView 渲染流程外，因此在使用时有以下限制：

- 原生组件的层级是**最高**的，所以页面中的其他组件无论设置 `z-index` 为多少，都无法盖在原生组件上。
  - 后插入的原生组件可以覆盖之前的原生组件。
- 原生组件还无法在 [picker-view](picker-view.html) 中使用。
  - 原生组件不支持在 [scroll-view](scroll-view.html)、[swiper](swiper.html)、[movable-view](movable-view.html) 中使用。
- 部分 CSS 样式无法应用于原生组件，例如：
  - 无法对原生组件设置 CSS 动画
  - 无法定义原生组件为 `position: fixed`
  - 不能在父级节点使用 `overflow: hidden` 来裁剪原生组件的显示区域
- 原生组件的事件监听不能使用 `bind:eventname` 的写法，只支持 `bindeventname`。原生组件也不支持 catch 和 capture 的事件绑定方式。
- 原生组件会遮挡 vConsole 弹出的调试面板。 _在工具上，原生组件是用 web 组件模拟的，因此很多情况并不能很好的还原真机的表现，建议开发者在使用到原生组件时尽量在真机上进行调试。_\*

## cover-view 与 cover-image

为了解决原生组件层级最高的限制。快应用专门提供了 [`cover-view`](cover-view.html) 和 [`cover-image`](cover-image.html) 组件，可以覆盖在**部分**原生组件上面。这两个组件也是原生组件，但是使用限制与其他原生组件有所不同。
