# movable-area

[movable-view](movable-view.html)的可移动区域。

| 属性 | 类型 | <div style="width: 50px">默认值 </div> | <div style="width: 50px">必填 </div> | 说明 |
| --- | --- | --- | --- | --- |
| scale-area | Boolean | false | 否 | 当里面的 movable-view 设置为支持双指缩放时，设置此值可将缩放手势生效区域修改为整个 movable-area |

## Bug & Tip

::: warning

- movable-area 必须设置 width 和 height 属性，其默认值为 10px\*\*
- 当 movable-view 小于 movable-area 时，movable-view 的移动范围是在 movable-area 内；
- 当 movable-view 大于 movable-area 时，movable-view 的移动范围必须包含 movable-area（x 轴方向和 y 轴方向分开考虑）

:::

## 示例代码

```html
<view class="section">
  <view class="section__title">movable-view区域小于movable-area</view>
  <movable-area style="height: 200px; width: 200px; background: red;">
    <movable-view style="height: 50px; width: 50px; background: blue;" x="{{x}}" y="{{y}}" direction="all">
    </movable-view>
  </movable-area>
  <view class="btn-area">
    <button size="mini" bindtap="tap">click me to move to (30px, 30px)</button>
  </view>
  <view class="section__title">movable-view区域大于movable-area</view>
  <movable-area style="height: 100px; width: 100px; background: red;">
    <movable-view style="height: 200px; width: 200px; background: blue;" direction="all"> </movable-view>
  </movable-area>
  <view class="section__title">可放缩</view>
  <movable-area style="height: 200px; width: 200px; background: red;" scale-area>
    <movable-view
      style="height: 50px; width: 50px; background: blue;"
      direction="all"
      bindchange="onChange"
      bindscale="onScale"
      scale
      scale-min="0.5"
      scale-max="4"
      scale-value="2"
    >
    </movable-view>
  </movable-area>
</view>
```

```js
Page({
  data: {
    x: 0,
    y: 0
  },
  tap: function(e) {
    this.setData({
      x: 30,
      y: 30
    })
  },
  onChange: function(e) {
    console.log(e.detail)
  },
  onScale: function(e) {
    console.log(e.detail)
  }
})
```
