# icon

图标组件，其中 size 默认单位为 px。

| 属性 | 类型 | <div style="width: 50px">默认值 </div> | <div style="width: 50px">必填 </div> | 说明 |
| --- | --- | --- | --- | --- |
| type | string |  | 是 | icon 的类型，有效值有：success, success_no_circle, warn, info, waiting, download, cancel, search, clear |
| size | number/string | 23 | 否 | icon 的大小 |
| color | string |  | 否 | icon 的颜色，同 css 的 color |

## 示例代码

```html
<!-- qxml -->
<view class="group">
  <block qa:for="{{iconSize}}">
    <icon type="success" size="{{item}}" />
  </block>
</view>

<view class="group">
  <block qa:for="{{iconType}}">
    <icon type="{{item}}" size="40" />
  </block>
</view>

<view class="group">
  <block qa:for="{{iconColor}}">
    <icon type="success" size="40" color="{{item}}" />
  </block>
</view>
```

```js
// js
Page({
  data: {
    iconSize: [20, 30, 40, 50, 60, 70],
    iconColor: ['red', 'orange', 'yellow', 'green', 'rgb(0,255,255)', 'blue', 'purple'],
    iconType: ['success', 'success_no_circle', 'info', 'warn', 'waiting', 'cancel', 'download', 'search', 'clear']
  }
})
```

![icon](~@assets/icon.png)
