# form

表单。将组件内的用户输入的[switch](switch.html) [input](input.html) [checkbox](checkbox.html) [slider](slider.html) [radio](radio.html) [picker](picker.html)的值 提交。

当点击 [form](form.html) 表单中 form-type 为 submit 的 [button](button.html) 组件时，会将表单组件中的 value 值进行提交，需要在表单组件中加上 name 来作为 key。

| 属性 | 类型 | <div style="width: 50px">默认值 </div> | <div style="width: 50px">必填 </div> | 说明 |
| --- | --- | --- | --- | --- |
| bindsubmit | eventhandle |  | 否 | 携带 form 中的数据触发 submit 事件，event.detail = {value : {'name': 'value'} , formId: ''} |
| bindreset | eventhandle |  | 否 | 表单重置时会触发 reset 事件 |

## 示例代码

```html
<form bindsubmit="formSubmit" bindreset="formReset">
  <view class="section section_gap">
    <view class="section__title">switch</view>
    <switch name="switch" checked />
  </view>
  <view class="section section_gap">
    <view class="section__title">slider</view>
    <slider name="slider" value="100" show-value></slider>
  </view>

  <view class="section">
    <view class="section__title">input</view>
    <input name="input" placeholder="please input here" />
  </view>
  <view class="section section_gap">
    <view class="section__title">radio</view>
    <radio-group name="radio-group">
      <label><radio value="radio1" />radio1</label>
      <label><radio value="radio2" />radio2</label>
    </radio-group>
  </view>
  <view class="section section_gap">
    <view class="section__title">checkbox</view>
    <checkbox-group name="checkbox">
      <label><checkbox value="checkbox1" />checkbox1</label>
      <label><checkbox value="checkbox2" checked />checkbox2</label>
    </checkbox-group>
  </view>
  <view class="btn-area">
    <button form-type="submit">Submit</button>
    <button form-type="reset">Reset</button>
  </view>
</form>
```

```js
Page({
  formSubmit: function(e) {
    console.log('form发生了submit事件，携带数据为：', e.detail.value)
  },
  formReset: function() {
    console.log('form发生了reset事件')
  }
})
```

![](~@assets/form.png)
