# cover-view

文本视图组件。该组件是[原生组件](native-component.html)，使用时请注意相关限制

可覆盖在原生组件之上包括 [map](map.html)、[video](video.html)、[canvas](canvas.html)

只支持嵌套 [cover-view](cover-view.html)、[cover-image](cover-image.html)。组件属性的长度单位默认为 px，支持传入单位(rpx/px)。

## 示例代码

```html
<video id="myVideo" src="http://techslides.com/demos/sample-videos/small.mp4" controls="{{false}}" event-model="bubble">
  <cover-view class="controls">
    <cover-view class="play" bindtap="play">
      <cover-image class="img" src="/path/to/icon_play" />
    </cover-view>
    <cover-view class="pause" bindtap="pause">
      <cover-image class="img" src="/path/to/icon_pause" />
    </cover-view>
    <cover-view class="time">00:00</cover-view>
  </cover-view>
</video>
```

```css
.controls {
  position: relative;
  top: 50%;
  height: 50px;
  margin-top: -25px;
  display: flex;
}
.play,
.pause,
.time {
  flex: 1;
  height: 100%;
}
.time {
  text-align: center;
  background-color: rgba(0, 0, 0, 0.5);
  color: white;
  line-height: 50px;
}
.img {
  width: 40px;
  height: 40px;
  margin: 5px auto;
}
```

```js
Page({
  onReady() {
    this.videoCtx = qa.createVideoContext('myVideo')
  },
  play() {
    this.videoCtx.play()
  },
  pause() {
    this.videoCtx.pause()
  }
})
```
