# 快应用组件

## 视图容器

| 名称                                         | 功能说明                                                       |
| -------------------------------------------- | -------------------------------------------------------------- |
| [movable-view](/component/movable-view.html) | 在页面中可以拖动滑动的视图容器                                 |
| [cover-image](/component/cover-image.html)   | 能够覆盖在原生组件之上的图片组件                               |
| [cover-view](/component/cover-view.html)     | 能够覆盖在原生组件之上的文本组件                               |
| [movable-area](/component/movable-area.html) | [movable-view](movable-view.html)的可移动区域                  |
| [scroll-view](/component/scroll-view.html)   | 可滚动的视图区域                                               |
| [swiper](/component/swiper.html)             | 滑块视图容器                                                   |
| [swiper-item](/component/swiper-item.html)   | 仅可放置在[swiper](swiper.html)组件中的子组件，宽高默认为 100% |
| [view](/component/view.html)                 | 视图容器                                                       |

## 基础内容

| 名称                                   | 功能说明 |
| -------------------------------------- | -------- |
| [icon](/component/icon.html)           | 图标     |
| [progress](/component/progress.html)   | 进度条   |
| [rich-text](/component/rich-text.html) | 富文本   |
| [text](/component/text.html)           | 文本     |

## 表单组件

| 名称                                                     | 功能说明                                            |
| -------------------------------------------------------- | --------------------------------------------------- |
| [button](/component/button.html)                         | 按钮                                                |
| [checkbox](/component/checkbox.html)                     | 多选项目                                            |
| [checkbox-group](/component/checkbox-group.html)         | 多项选择器，内部由多个[checkbox](checkbox.html)组成 |
| [form](/component/form.html)                             | 表单                                                |
| [input](/component/input.html)                           | 输入框                                              |
| [label](/component/label.html)                           | 用来绑定表单组件的标签                              |
| [picker](/component/picker.html)                         | 从底部弹起的滚动选择器                              |
| [picker-view](/component/picker-view.html)               | 嵌入页面的滚动选择器                                |
| [picker-view-column](/component/picker-view-column.html) | 滚动选择器子项                                      |
| [radio](/component/radio.html)                           | 单选项目                                            |
| [radio-group](/component/radio-group.html)               | 单项选择器，内部由多个 [radio](radio.html) 组成     |
| [slider](/component/slider.html)                         | 滑动选择器                                          |
| [switch](/component/switch.html)                         | 开关选择器                                          |
| [textarea](/component/textarea.html)                     | 多行输入框                                          |

## 导航

| 名称                                   | 功能说明 |
| -------------------------------------- | -------- |
| [navigator](/component/navigator.html) | 页面链接 |

## 媒体组件

| 名称                           | 功能说明 |
| ------------------------------ | -------- |
| [audio](/component/audio.html) | 音频     |
| [image](/component/image.html) | 图片     |
| [video](/component/video.html) | 视频     |

## 地图

| 名称                       | 功能说明 |
| -------------------------- | -------- |
| [map](/component/map.html) | 地图     |

## 画布

| 名称                             | 功能说明 |
| -------------------------------- | -------- |
| [canvas](/component/canvas.html) | 画布     |

## 开放能力

| 名称                                 | 功能说明       |
| ------------------------------------ | -------------- |
| [web-view](/component/web-view.html) | 承载网页的容器 |

## 原生组件说明

| 名称                                                 | 功能说明     |
| ---------------------------------------------------- | ------------ |
| [native-component](/component/native-component.html) | \## 原生组件 |

快应用中的部分组件是由客户端创建的原生组件，这些组件有：

- [`canvas`](/component/canvas.html)
- [`input`](/component/input.html)（仅在 focus 时表现为原生组件）
- [`map`](/component/map.html)
- [`textarea`](/component/textarea.html)
- [`video`](/component/video.html)

## 原生组件的使用限制

原生组件脱离在 WebView 渲染流程外，需要留意以下限制：

- 原生组件的层级是**最高**的，页面中的其他组件无论设置 `z-index` 为多少，都无法盖在原生组件上
