# qa.setNavigationBarColor(Object object)

设置当前页面的导航条颜色

## 参数

### Object object

| 属性 | 类型 | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| frontColor | string |  | 是 | 前景颜色值，包括按钮、标题、状态栏的颜色，只支持 #ffffff 和 #000000 |
| backgroundColor | string |  | 是 | 背景颜色值，支持十六进制颜色 |
| animation | Object |  | 是 | 颜色切换的过渡动画效果 |
| success | function |  | 否 | 接口调用成功的回调函数 |
| fail | function |  | 否 | 接口调用失败的回调函数 |
| complete | function |  | 否 | 接口调用结束的回调函数（调用成功、失败都会执行） |

**object.animation 的结构**

| 属性 | 类型 | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| duration | number | 0 | 否 | 过渡动画变化时间，单位 ms |
| timingFunc | string | 'linear' | 否 | 过渡动画变化方式 |

**object.animation.timingFunc 的合法值**

| 值          | 说明                       |
| ----------- | -------------------------- |
| 'linear'    | 从头到尾的速度是相同的动画 |  |
| 'easeIn'    | 以低速开始的动画             |  |
| 'easeOut'   | 以低速结束的动画             |  |
| 'easeInOut' | 以低速开始和结束的动画       |  |

## 示例代码

```js
qa.setNavigationBarColor({
  frontColor: '#ffffff',
  backgroundColor: '#ff0000',
  animation: {
    duration: 500,
    timingFunc: 'easeOut'
  }
})
```
