# qa.showModal(Object object)

显示模态对话框

## 参数

### Object object

| 属性 | 类型 | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| title | string |  | 是 | 提示的标题 |
| content | string |  | 是 | 提示的内容 |
| showCancel | boolean | true | 否 | 是否显示取消按钮 |
| cancelText | string | '取消' | 否 | 取消按钮的文字，最多 4 个字符 |
| cancelColor | string | #0086FF | 否 | 取消按钮的文字颜色 |
| confirmText | string | '确定' | 否 | 确认按钮的文字，最多 4 个字符 |
| confirmColor | string | #FFFFFF | 否 | 确认按钮的文字颜色 |
| success | function |  | 否 | 接口调用成功的回调函数 |
| fail | function |  | 否 | 接口调用失败的回调函数 |
| complete | function |  | 否 | 接口调用结束的回调函数（调用成功、失败都会执行） |

#### object.success 回调函数

##### 参数

###### Object res

| 属性    | 类型    | 说明                                                                                    |
| ------- | ------- | --------------------------------------------------------------------------------------- |
| confirm | boolean | 为 true 时，表示用户点击了确定按钮                                                      |  |
| cancel  | boolean | 为 true 时，表示用户点击了取消（用于 Android 系统区分点击蒙层关闭还是点击取消按钮关闭） |  |

## 示例代码

```js
qa.showModal({
  title: '提示',
  content: '这是一个模态弹窗',
  success(res) {
    if (res.confirm) {
      console.log('用户点击确定')
    } else if (res.cancel) {
      console.log('用户点击取消')
    }
  }
})
```
