# qa.setStorage(Object object)

将指定的 key-value 键值对数据存储在本地缓存中，如果已有该 key 值，将会覆盖原先 key 对应的内容

数据存储生命周期和快应用本身一致，即除用户主动删除或超过一定时间被自动清理，否则数据都一直可用。

单个 key 允许存储的最大数据长度为 1MB，所有数据存储上限为 10MB。

## 参数

### Object object

| 属性 | 类型 | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| key | string |  | 是 | 本地缓存中指定的 key |
| data | any |  | 是 | 需要存储的内容。只支持原生类型、Date、及能够通过`JSON.stringify`序列化的对象。 |
| success | function |  | 否 | 接口调用成功的回调函数 |
| fail | function |  | 否 | 接口调用失败的回调函数 |
| complete | function |  | 否 | 接口调用结束的回调函数（调用成功、失败都会执行） |

## 示例代码

```js
qa.setStorage({
  key: 'key',
  data: 'value'
})
```

```js
try {
  qa.setStorageSync('key', 'value')
} catch (e) {}
```
