# Object qa.getStorageInfoSync()

[qa.getStorageInfo](qa.getStorageInfo.html) 的同步版本接口

## 返回值

### Object object

| 属性        | 类型            | 说明                        |
| ----------- | --------------- | --------------------------- |
| keys        | Array.\<string> | 当前 storage 中所有的 key   |
| currentSize | number          | 当前占用的空间大小, 单位 KB, 清空时不为0 |
| limitSize   | number          | 限制的空间大小，单位 KB     |

## 示例代码

```js
qa.getStorageInfo({
  success(res) {
    console.log(res.keys)
    console.log(res.currentSize)
    console.log(res.limitSize)
  }
})
```

```js
try {
  const res = qa.getStorageInfoSync()
  console.log(res.keys)
  console.log(res.currentSize)
  console.log(res.limitSize)
} catch (e) {
  // Do something when catch error
}
```
