# qa.navigateToQuickapp(Object object)

打开另一个快应用

## 参数

### Object object

| 属性 | 类型 | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| packageName | string |  | 是 | 要打开的快应用包名 |
| path | string |  | 否 | 打开的页面路径，如果为空则打开首页。path 中 ? 后面的部分会成为 query，在快应用的 `App.onLaunch`、`App.onShow` 和 `Page.onLoad` 的回调函数或小游戏的 [qa.onAppShow](/api/base/app/qa.onAppShow.html) 回调函数、[qa.getLaunchOptionsSync](/api/base/app/qa.getLaunchOptionsSync.html) 中可以获取到 query 数据。 |
| extraData | object |  | 否 | 需要传递给目标快应用的数据。 |
| success | function |  | 否 | 接口调用成功的回调函数 |
| fail | function |  | 否 | 接口调用失败的回调函数 |
| complete | function |  | 否 | 接口调用结束的回调函数（调用成功、失败都会执行） |

## 示例代码

```js
qa.navigateToQuickapp({
  packageName: 'com.example.demo',
  path: 'page/index/index?id=123',
  extraData: {
    foo: 'bar'
  },
  envVersion: 'develop',
  success(res) {
    // 打开成功
  }
})
```
