# qa.closeSocket(Object object)

关闭WebSocket连接

## 参数

### Object object

| 属性 | 类型 | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| code | number | 1000（表示正常关闭连接） | 否 | 数值表示关闭连接的状态号，表示连接被关闭的原因，参考[RFC 6455](http://tools.ietf.org/html/rfc6455#section-7.4) |
| reason | string |  | 否 | 表示连接被关闭的原因的字符串，该字符串必须是不长于 123 字节的 UTF-8 文本（不是字符）。 |
| success | function |  | 否 | 接口调用成功的回调函数 |
| fail | function |  | 否 | 接口调用失败的回调函数 |
| complete | function |  | 否 | 接口调用结束的回调函数（调用成功、失败都会执行） |

## 示例代码

```js
qa.connectSocket({
  url: 'test.php'
})

//注意这里有时序问题，
//如果 qa.connectSocket 还没回调 qa.onSocketOpen，而先调用 qa.closeSocket，那么就做不到关闭 WebSocket 的目的。
//必须在 WebSocket 打开期间调用 qa.closeSocket 才能关闭。
qa.onSocketOpen(function() {
  qa.closeSocket()
})

qa.onSocketClose(function(res) {
  console.log('WebSocket 已关闭！')
})
```
