# qa.onNetworkStatusChange(function callback)

监听网络状态变化，包括当前连接状态和所连接的网络类型

## 参数

### function callback

网络状态变化事件的回调函数

#### 参数

##### Object res

| 属性 |  类型 |  说明 |
| --- |  --- |  --- |
| isConnected |  boolean |  当前是否接入网络 |
| networkType |  string |  当前连接的网络类型 |

**networkType 的合法值**

| 值      | 说明                       |
| ------- | -------------------------- |
| wifi    | wifi 网络                  |  |
| 2g      | 2g 网络                    |  |
| 3g      | 3g 网络                    |  |
| 4g      | 4g 网络                    |  |
| unknown | Android 下不常见的网络类型 |  |
| none    | 无网络                     |  |

## 示例代码

```js
qa.onNetworkStatusChange(function(res) {
  console.log(res.isConnected)
  console.log(res.networkType)
})
```
