# qa.startBluetoothDevicesDiscovery(Object object)

开始搜寻附近的蓝牙外围设备。**此操作比较耗费系统资源，请在搜索并连接到设备后调用 [qa.stopBluetoothDevicesDiscovery](qa.stopBluetoothDevicesDiscovery.html) 方法停止搜索。**

## 参数

### Object object

| 属性 | 类型 | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| services | Array.\<string> |  | 否 | 要搜索的蓝牙设备主 service 的 uuid 列表。某些蓝牙设备会广播自己的主 service 的 uuid。如果设置此参数，则只搜索广播包有对应 uuid 的主服务的蓝牙设备。建议主要通过该参数过滤掉周边不需要处理的其他蓝牙设备。 |
| allowDuplicatesKey | boolean | false | 否 | 是否允许重复上报同一设备。如果允许重复上报，则 [qa.onBlueToothDeviceFound](./qa.onBlueToothDeviceFound.html) 方法会多次上报同一设备，但是 RSSI 值会有不同。 |
| interval | number | 0 | 否 | 上报设备的间隔。0 表示找到新设备立即上报，其他数值根据传入的间隔上报。 |
| success | function |  | 否 | 接口调用成功的回调函数 |
| fail | function |  | 否 | 接口调用失败的回调函数 |
| complete | function |  | 否 | 接口调用结束的回调函数（调用成功、失败都会执行） |

## 错误

| 错误码 | 错误信息             | 说明                                          |
| ------ | -------------------- | --------------------------------------------- |
| 0      | ok                   | 正常                                          |
| 10000  | not init             | 未初始化蓝牙适配器                            |
| 10001  | not available        | 当前蓝牙适配器不可用                          |
| 10002  | no device            | 没有找到指定设备                              |
| 10003  | connection fail      | 连接失败                                      |
| 10004  | no service           | 没有找到指定服务                              |
| 10005  | no characteristic    | 没有找到指定特征值                            |
| 10006  | no connection        | 当前连接已断开                                |
| 10007  | property not support | 当前特征值不支持此操作                        |
| 10008  | system error         | 其余所有系统上报的异常                        |
| 10009  | system not support   | 系统不支持                                    |
| 10012  | operate time out     | 连接超时                                      |
| 10013  | invalid_data         | 连接 deviceId 为空或者是格式不正确            |

## 示例代码

```js
// 以快应用硬件平台的蓝牙智能灯为例，主服务的 UUID 是 FEE7。传入这个参数，只搜索主服务 UUID 为 FEE7 的设备
qa.startBluetoothDevicesDiscovery({
  services: ['FEE7'],
  success(res) {
    console.log(res)
  }
})
```
