# CanvasContext.setTextAlign(string align)

设置文字的对齐

## 参数

### string align

文字的对齐方式

**align 的合法值**

| 值     | 说明     |
| ------ | -------- |
| left   | 左对齐   |  |
| center | 居中对齐 |  |
| right  | 右对齐   |  |

## 示例代码

```js
const ctx = qa.createCanvasContext('myCanvas')

ctx.setStrokeStyle('red')
ctx.moveTo(150, 20)
ctx.lineTo(150, 170)
ctx.stroke()

ctx.setFontSize(15)
ctx.setTextAlign('left')
ctx.fillText('textAlign=left', 150, 60)

ctx.setTextAlign('center')
ctx.fillText('textAlign=center', 150, 80)

ctx.setTextAlign('right')
ctx.fillText('textAlign=right', 150, 100)

ctx.draw()
```

![](data:image/png;base64,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)
