# CanvasContext.rotate(number rotate)

以原点为中心顺时针旋转当前坐标轴。多次调用旋转的角度会叠加。原点可以用 `translate` 方法修改。

## 参数

### number rotate

旋转角度，以弧度计 degrees \* Math.PI/180；degrees 范围为 0-360

## 示例代码

```js
const ctx = qa.createCanvasContext('myCanvas')

ctx.strokeRect(100, 10, 150, 100)
ctx.rotate((20 * Math.PI) / 180)
ctx.strokeRect(100, 10, 150, 100)
ctx.rotate((20 * Math.PI) / 180)
ctx.strokeRect(100, 10, 150, 100)

ctx.draw()
```

![](data:image/png;base64,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)
