# CanvasContext.fillRect(number x, number y, number width, number height)

填充一个矩形。用 [`setFillStyle`](CanvasContext.setFillStyle.html) 设置矩形的填充色，如果没设置默认是黑色。

## 参数

### number x

矩形路径左上角的横坐标

### number y

矩形路径左上角的纵坐标

### number width

矩形路径的宽度

### number height

矩形路径的高度

## 示例代码

```js
const ctx = qa.createCanvasContext('myCanvas')
ctx.setFillStyle('red')
ctx.fillRect(10, 10, 150, 75)
ctx.draw()
```

![](data:image/png;base64,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)
