# CanvasContext.draw(boolean reserve, function callback)

将之前在绘图上下文中的描述（路径、变形、样式）画到 canvas 中。

## 参数

### boolean reserve

本次绘制是否接着上一次绘制。即 reserve 参数为 false，则在本次调用绘制之前 native 层会先清空画布再继续绘制；若 reserve 参数为 true，则保留当前画布上的内容，本次调用 drawCanvas 绘制的内容覆盖在上面，默认 false。

### function callback

绘制完成后执行的回调函数

## 示例代码

第二次 draw() reserve 为 true。所以保留了上一次的绘制结果，在上下文设置的 fillStyle 'red' 也变成了默认的 'black'。

```js
const ctx = qa.createCanvasContext('myCanvas')

ctx.setFillStyle('red')
ctx.fillRect(10, 10, 150, 100)
ctx.draw()
ctx.fillRect(50, 50, 150, 100)
ctx.draw(true)
```

![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAUAAAACoCAYAAACR8DfxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAewSURBVHhe7dpBjtwwEAPA+f+nN9icE8AHach2V4C9GRqKNuuUz49/GtCABpY28Fl6b9fWgAY08ANAH4EGNLC2AQCuffUurgENANA3oAENrG0AgGtfvYtrQAMA9A1oQANrG3gE4Ofz+fGnA9+Ab2DSN/BE9ccAPjnMMxrQgAYaGviF+sm/R089PezJD3pGAxrQwO0GnpoFwNtvwvka0MDXGwDg1yv3gxrQQEsDAGx5E3JoQANfbwCAX6/cD2pAAy0NALDlTcihAQ18vQEAfr1yP6gBDbQ0AMCWNyGHBjTw9QYA+PXK/aAGNNDSQA7A3/+B7U8Hp7+BlmXJMaIBAJ4eoPOyqI+YnZAtDQAQWFmwTvffsiw5RjQAwNMDdF4W1BGzE7KlAQACKwvW6f5bliXHiAYAeHqAzsuCOmJ2QrY0AEBgZcE63X/LsuQY0QAATw/QeVlQR8xOyJYGAAisLFin+29ZlhwjGgDg6QE6LwvqiNkJ2dIAAIGVBet0/y3LkmNEAwA8PUDnZUEdMTshWxoAILCyYJ3uv2VZcoxoAICnB+i8LKgjZidkSwMABFYWrNP9tyxLjhENAPD0AJ2XBXXE7IRsaQCAwMqCdbr/lmXJMaIBAJ4eoPOyoI6YnZAtDQAQWFmwTvffsiw5RjQAwNMDdF4W1BGzE7KlAQACKwvW6f5bliXHiAYAeHqAzsuCOmJ2QrY0AEBgZcE63X/LsuQY0QAATw/QeVlQR8xOyJYGAAisLFin+29ZlhwjGgDg6QE6LwvqiNkJ2dIAAIGVBet0/y3LkmNEAwA8PUDnZUEdMTshWxoAILCyYJ3uv2VZcoxoAICnB+i8LKgjZidkSwMABFYWrNP9tyxLjhENAPD0AJ2XBXXE7IRsaQCAwMqCdbr/lmXJMaIBAJ4eoPOyoI6YnZAtDQAQWFmwTvffsiw5RjQAwNMDdF4W1BGzE7KlAQACKwvW6f5bliXHiAYAeHqAzsuCOmJ2QrY0AEBgZcE63X/LsuQY0QAATw/QeVlQR8xOyJYGAAisLFjb+m9Zvhx/GwDgtgG6bxZ88FQ1AEAgZEHY1n/V/IUB4LYBum8WfOZUNQBAIGRB2NZ/1fyFAeC2AbpvFnzmVDUAQCBkQdjWf9X8hQHgtgG6bxZ85lQ1AEAgZEHY1n/V/IUB4LYBum8WfOZUNQBAIGRB2NZ/1fyFAeC2AbpvFnzmVDUAQCBkQdjWf9X8hQHgtgG6bxZ85lQ1AEAgZEHY1n/V/IUB4LYBum8WfOZUNQBAIGRB2NZ/1fyFAeC2AbpvFnzmVDUAQCBkQdjWf9X8hQHgtgG6bxZ85lQ1AEAgZEHY1n/V/IUB4LYBum8WfOZUNQBAIGRB2NZ/1fyFAeC2AbpvFnzmVDUAQCBkQdjWf9X8hQHgtgG6bxZ85lQ1AEAgZEHY1n/V/IUB4LYBum8WfOZUNQBAIGRB2NZ/1fyFAeC2AbpvFnzmVDUAQCBkQdjWf9X8hQHgtgG6bxZ85lQ1AEAgZEHY1n/V/IUB4LYBum8WfOZUNQBAIGRB2NZ/1fyFAeC2AbpvFnzmVDUAQCBkQdjWf9X8hQHgtgG6bxZ85lQ1AEAgZEHY1n/V/IUB4LYBum8WfOZUNQBAIGRB2NZ/1fyFAeC2AbpvFnzmVDUAQCBkQdjWf9X8hQHgtgG6bxZ85lQ1AEAgZEHY1n/V/IUB4LYBum8WfOZUNQBAIGRB2NZ/1fyFAeC2AbpvFnzmVDUAQCBkQdjWf9X8hQHgtgG6bxZ85lQ1AEAgZEHY1n/V/IUB4LYBum8WfOZUNQBAIGRB2NZ/1fyFAeC2AbpvFnzmVDUAQCBkQdjWf9X8hQHgtgG6bxZ85lQ1AEAgZEHY1n/V/IUB4LYBum8WfOZUNQBAIGRB2NZ/1fyFAeC2AbpvFnzmVDWQA7Cqhn+EAUUWirf23/7dL8sHwP+98LcO0L2ysC8Dpv26AARgFoRtILeLsCwfAAEIwG8ivAyY9usCEIAABGC7U9fyARCAAATgNWDaDwYgAAEIwHanruUDIAABCMBrwLQfDEAAAhCA7U5dywdAAAIQgNeAaT8YgAAEIADbnbqWD4AABCAArwHTfjAAAQhAALY7dS0fAAEIQABeA6b9YAACEIAAbHfqWj4AAhCAALwGTPvBAAQgAAHY7tS1fAAEIAABeA2Y9oMBCEAAArDdqWv5AAhAAALwGjDtBwMQgAAEYLtT1/IBEIAABOA1YNoPBiAAAQjAdqeu5QMgAAEIwGvAtB8MQAACEIDtTl3LB0AAAhCA14BpPxiAAAQgANudupYPgAAEIACvAdN+MAABCEAAtjt1LR8AAQhAAF4Dpv1gAAIQgABsd+paPgACEIAAvAZM+8EABCAAAdju1LV8AAQgAAF4DZj2gwEIQAACsN2pa/kACEAAAvAaMO0HAxCAAARgu1PX8gEQgAAE4DVg2g8GIAABCMB2p67lAyAAAQjAa8C0H3wcwN8D/enAN+AbmPINPEH68+Qhz2hAAxp4YwMAfONbdScNaOBRAwB8VJOHNKCBNzYAwDe+VXfSgAYeNQDARzV5SAMaeGMDAHzjW3UnDWjgUQMAfFSThzSggTc2AMA3vlV30oAGHjUAwEc1eUgDGnhjA38AVQw3JW8fPUMAAAAASUVORK5CYII=)

## 示例代码

第二次 draw() reserve 为 false。所以没有保留了上一次的绘制结果和在上下文设置的 fillStyle 'red'。

```js
const ctx = qa.createCanvasContext('myCanvas')

ctx.setFillStyle('red')
ctx.fillRect(10, 10, 150, 100)
ctx.draw()
ctx.fillRect(50, 50, 150, 100)
ctx.draw()
```

![](data:image/png;base64,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)
