# [CanvasGradient](CanvasGradient.html) CanvasContext.createCircularGradient(number x, number y, number r)

创建一个圆形的渐变颜色。起点在圆心，终点在圆环。返回的`CanvasGradient`对象需要使用 [CanvasGradient.addColorStop()](CanvasGradient.addColorStop.html) 来指定渐变点，至少要两个。

## 参数

### number x

圆心的 x 坐标

### number y

圆心的 y 坐标

### number r

圆的半径

## 返回值

### [CanvasGradient](CanvasGradient.html)

## 示例代码

```js
const ctx = qa.createCanvasContext('myCanvas')

// Create circular gradient
const grd = ctx.createCircularGradient(75, 50, 50)
grd.addColorStop(0, 'red')
grd.addColorStop(1, 'white')

// Fill with gradient
ctx.setFillStyle(grd)
ctx.fillRect(10, 10, 150, 80)
ctx.draw()
```

![](data:image/png;base64,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)
