# CanvasContext.closePath()

关闭一个路径。会连接起点和终点。如果关闭路径后没有调用 `fill` 或者 `stroke` 并开启了新的路径，那之前的路径将不会被渲染。

## 示例代码

```js
const ctx = qa.createCanvasContext('myCanvas')
ctx.moveTo(10, 10)
ctx.lineTo(100, 10)
ctx.lineTo(100, 100)
ctx.closePath()
ctx.stroke()
ctx.draw()
```

![](data:image/png;base64,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)

```js
const ctx = qa.createCanvasContext('myCanvas')
// begin path
ctx.rect(10, 10, 100, 30)
ctx.closePath()

// begin another path
ctx.beginPath()
ctx.rect(10, 40, 100, 30)

// only fill this rect, not in current path
ctx.setFillStyle('blue')
ctx.fillRect(10, 70, 100, 30)

ctx.rect(10, 100, 100, 30)

// it will fill current path
ctx.setFillStyle('red')
ctx.fill()
ctx.draw()
```

![](data:image/png;base64,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)
