# CanvasContext.clip()

从原始画布中剪切任意形状和尺寸。一旦剪切了某个区域，则所有之后的绘图都会被限制在被剪切的区域内（不能访问画布上的其他区域）。可以在使用 `clip` 方法前通过使用 `save` 方法对当前画布区域进行保存，并在以后的任意时间通过`restore`方法对其进行恢复。

## 示例代码

```js
const ctx = qa.createCanvasContext('myCanvas')

qa.downloadFile({
  url:
    'http://is5.mzstatic.com/image/thumb/Purple128/v4/75/3b/90/753b907c-b7fb-5877-215a-759bd73691a4/source/50x50bb.jpg',
  success: function(res) {
    ctx.save()
    ctx.beginPath()
    ctx.arc(50, 50, 25, 0, 2 * Math.PI)
    ctx.clip()
    ctx.drawImage(res.tempFilePath, 25, 25)
    ctx.restore()
    ctx.draw()
  }
})
```

![](data:image/png;base64,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)
