# qa.setTrustedUrls(Array array)

为组件 [web-view](/component/web-view.html) 所承载网页，配置可信任的网址（支持正则表达式）。

## 参数

### Array trustedUrlsArray

将认为可信任的网址，以数组的形式传入，届时该网页即可调用 [web-view](/component/web-view.html) 组件中所提供的 API 能力；对于数组中所配置的子项，可以是完整的网页地址，也可以是符合预期的正则表达式（[web-view](/component/web-view.html) 的属性 `src` 所指定的链接，默认是可信任的，不必填入）。

## 返回值

无返回值。

## 示例代码

```js
// app.js
qa.setTrustedUrls([
  'https://your-domain-name.cn/explore/',
  /^https?:\/\/your-domain-name.com/,
  /^https?:\/\/(www\.)your-domain-name.com/,
  /^https?:\/\/([a-z0-9]*\.)your-domain-name.com/
])
```
