# boolean qa.canIUse(string schema)

判断指定API（含调用方式/回调/参数/返回值/返回值的属性）或者组件（含属性）在当前快应用版本是否可用。

## 参数

### string schema

对于API，支持下列调用Schema：
```
 `${API}.${method}.${param}.${options}`
```

对于组件，支持下列调用Schema:
```
 `${component}.${attribute}.${option}` 
```

## 返回值

### boolean

指定API或者组件在当前快应用版本是否可用

## 参数说明

|     Schema     |                            含义                            |
| :------------: | :--------------------------------------------------------: |
|    `${API}`    |                          API 名字                          |
|  `${method}`   | 调用方式，支持的有效值为 return, success, object, callback |
|   `${param}`   |                       参数 or 返回值                       |
|  `${options}`  |                        参数的可选值                        |
| `${component}` |                          组件名字                          |
| `${attribute}` |                          组件属性                          |
|  `${option}`   |                      组件属性的可选值                      |

## 示例代码

```js
qa.canIUse('openBluetoothAdapter')
qa.canIUse('getSystemInfoSync.return.screenWidth')
qa.canIUse('getSystemInfo.success.screenWidth')
qa.canIUse('showToast.object.image')
qa.canIUse('onCompassChange.callback.direction')
qa.canIUse('request.object.method.GET')

qa.canIUse('scroll-view')
qa.canIUse('text.selectable')
qa.canIUse('button.type.primary')
```
