## 基础

| 名称 | 功能说明 |
| --- | --- |
| [qa.canIUse](/api/base/qa.canIUse.html) | 判断指定API（含调用方式/回调/参数/返回值/返回值的属性）或者组件（含属性）在当前快应用版本是否可用。 |
| [qa.base64ToArrayBuffer](/api/base/qa.base64ToArrayBuffer.html) | 将 Base64 字符串转成 ArrayBuffer 对象 |
| [qa.arrayBufferToBase64](/api/base/qa.arrayBufferToBase64.html) | 将 ArrayBuffer 对象转成 Base64 字符串 |

### 系统

#### 系统信息

| 名称 | 功能说明 |
| --- | --- |
| [qa.getSystemInfoSync](/api/base/system/qa.getSystemInfoSync.html) | [qa.getSystemInfo](/api/base/system/qa.getSystemInfo.html) 的同步版本接口 |
| [qa.getSystemInfo](/api/base/system/qa.getSystemInfo.html) | 获取系统信息 |

### 快应用

#### 应用级事件

| 名称                                                        | 功能说明                             |
| ----------------------------------------------------------- | ------------------------------------ |
| [qa.onError](/api/base/app/qa.onError.html)                 | 监听快应用错误事件                   |
| [qa.onAppShow](/api/base/app/qa.onAppShow.html)             | 监听快应用切前台事件                 |
| [qa.onAppHide](/api/base/app/qa.onAppHide.html)             | 监听快应用切后台事件                 |
| [qa.offPageNotFound](/api/base/app/qa.offPageNotFound.html) | 取消监听快应用要打开的页面不存在事件 |
| [qa.offError](/api/base/app/qa.offError.html)               | 取消监听快应用错误事件               |
| [qa.offAppShow](/api/base/app/qa.offAppShow.html)           | 取消监听快应用切前台事件             |
| [qa.offAppHide](/api/base/app/qa.offAppHide.html)           | 取消监听快应用切后台事件             |

### 调试

| 名称                                                        | 功能说明             |
| ----------------------------------------------------------- | -------------------- |
| [qa.setEnableDebug](/api/base/debug/qa.setEnableDebug.html) | 设置是否打开调试开关 |

#### console

| 名称 | 功能说明 |
| --- | --- |
| [console.debug](/api/base/debug/console.debug.html) | 向调试面板中打印 debug 日志 |
| [console.error](/api/base/debug/console.error.html) | 向调试面板中打印 error 日志 |
| [console.group](/api/base/debug/console.group.html) | 在调试面板中创建一个新的分组 |
| [console.groupEnd](/api/base/debug/console.groupEnd.html) | 结束由 [console.group](/api/base/debug/console.group.html) 创建的分组 |
| [console.info](/api/base/debug/console.info.html) | 向调试面板中打印 info 日志 |
| [console.log](/api/base/debug/console.log.html) | 向调试面板中打印 log 日志 |
| [console.warn](/api/base/debug/console.warn.html) | 向调试面板中打印 warn 日志 |

### 定时器

| 名称                                                | 功能说明                        |
| --------------------------------------------------- | ------------------------------- |
| [clearInterval](/api/base/timer/clearInterval.html) | 取消由 setInterval 设置的定时器 |
| [clearTimeout](/api/base/timer/clearTimeout.html)   | 取消由 setTimeout 设置的定时器  |
| [setInterval](/api/base/timer/setInterval.html)     | 设定一个定时器                  |
| [setTimeout](/api/base/timer/setTimeout.html)       | 设定一个定时器                  |

## 路由

| 名称                                               | 功能说明                                         |
| -------------------------------------------------- | ------------------------------------------------ |
| [qa.switchTab](/api/route/qa.switchTab.html)       | 跳转到 tabBar 页面，并关闭其他所有非 tabBar 页面 |
| [qa.reLaunch](/api/route/qa.reLaunch.html)         | 关闭所有页面，打开到应用内的某个页面             |
| [qa.redirectTo](/api/route/qa.redirectTo.html)     | 关闭当前页面，跳转到应用内的某个页面             |
| [qa.navigateTo](/api/route/qa.navigateTo.html)     | 保留当前页面，跳转到应用内的某个页面             |
| [qa.navigateBack](/api/route/qa.navigateBack.html) | 关闭当前页面，返回上一页面或多级页面             |

## 界面

### 交互

| 名称                                                              | 功能说明            |
| ----------------------------------------------------------------- | ------------------- |
| [qa.showToast](/api/ui/interaction/qa.showToast.html)             | 显示消息提示框      |
| [qa.showModal](/api/ui/interaction/qa.showModal.html)             | 显示模态对话框      |
| [qa.showLoading](/api/ui/interaction/qa.showLoading.html)         | 显示 loading 提示框 |
| [qa.showActionSheet](/api/ui/interaction/qa.showActionSheet.html) | 显示操作菜单        |
| [qa.hideToast](/api/ui/interaction/qa.hideToast.html)             | 隐藏消息提示框      |
| [qa.hideLoading](/api/ui/interaction/qa.hideLoading.html)         | 隐藏 loading 提示框 |

### 导航栏

| 名称 | 功能说明 |
| --- | --- |
| [qa.showNavigationBarLoading](/api/ui/navigation-bar/qa.showNavigationBarLoading.html) | 显示当前页面的导航条加载动画 |
| [qa.setNavigationBarTitle](/api/ui/navigation-bar/qa.setNavigationBarTitle.html) | 设置当前当前页面的标题，即时生效 |
| [qa.setNavigationBarColor](/api/ui/navigation-bar/qa.setNavigationBarColor.html) | 设置当前页面的导航条颜色 |
| [qa.hideNavigationBarLoading](/api/ui/navigation-bar/qa.hideNavigationBarLoading.html) | 隐藏当前页面的导航条加载动画 |

### 背景

| 名称 | 功能说明 |
| --- | --- |
| [qa.setBackgroundTextStyle](/api/ui/background/qa.setBackgroundTextStyle.html) | 动态设置下拉背景字体、loading 图的样式 |
| [qa.setBackgroundColor](/api/ui/background/qa.setBackgroundColor.html) | 动态设置窗口的背景色 |

### Tab Bar

| 名称                                                              | 功能说明                         |
| ----------------------------------------------------------------- | -------------------------------- |
| [qa.showTabBarRedDot](/api/ui/tab-bar/qa.showTabBarRedDot.html)   | 显示 tabBar 某一项的右上角的红点 |
| [qa.showTabBar](/api/ui/tab-bar/qa.showTabBar.html)               | 显示 tabBar                      |
| [qa.setTabBarStyle](/api/ui/tab-bar/qa.setTabBarStyle.html)       | 动态设置 tabBar 的整体样式       |
| [qa.setTabBarItem](/api/ui/tab-bar/qa.setTabBarItem.html)         | 动态设置 tabBar 某一项的内容     |
| [qa.setTabBarBadge](/api/ui/tab-bar/qa.setTabBarBadge.html)       | 为 tabBar 某一项的右上角添加文本 |
| [qa.removeTabBarBadge](/api/ui/tab-bar/qa.removeTabBarBadge.html) | 移除 tabBar 某一项右上角的文本   |
| [qa.hideTabBarRedDot](/api/ui/tab-bar/qa.hideTabBarRedDot.html)   | 隐藏 tabBar 某一项的右上角的红点 |
| [qa.hideTabBar](/api/ui/tab-bar/qa.hideTabBar.html)               | 隐藏 tabBar                      |

### 字体

| 名称                                                 | 功能说明         |
| ---------------------------------------------------- | ---------------- |
| [qa.loadFontFace](/api/ui/font/qa.loadFontFace.html) | 动态加载网络字体 |

### 下拉刷新

| 名称                                                                              | 功能说明             |
| --------------------------------------------------------------------------------- | -------------------- |
| [qa.stopPullDownRefresh](/api/ui/pull-down-refresh/qa.stopPullDownRefresh.html)   | 停止当前页面下拉刷新 |
| [qa.startPullDownRefresh](/api/ui/pull-down-refresh/qa.startPullDownRefresh.html) | 开始下拉刷新         |

### 滚动

| 名称                                                   | 功能说明             |
| ------------------------------------------------------ | -------------------- |
| [qa.pageScrollTo](/api/ui/scroll/qa.pageScrollTo.html) | 将页面滚动到目标位置 |

### 动画

| 名称 | 功能说明 |
| --- | --- |
| [qa.createAnimation](/api/ui/animation/qa.createAnimation.html) | 创建一个动画实例 [animation](/api/ui/animation/Animation.html) |

#### Animation

| 名称 | 功能说明 |
| --- | --- |
| [Animation.height](/api/ui/animation/Animation.height.html) | 设置高度 |
| [Animation.left](/api/ui/animation/Animation.left.html) | 设置 left 值 |
| [Animation.matrix](/api/ui/animation/Animation.matrix.html) | 同 [transform-function matrix](https://developer.mozilla.org/en-US/docs/Web/CSS/transform-function/matrix) |
| [Animation.matrix3d](/api/ui/animation/Animation.matrix3d.html) | 同 [transform-function matrix3d](https://developer.mozilla.org/en-US/docs/Web/CSS/transform-function/matrix3d) |
| [Animation.opacity](/api/ui/animation/Animation.opacity.html) | 设置透明度 |
| [Animation.right](/api/ui/animation/Animation.right.html) | 设置 right 值 |
| [Animation.rotate](/api/ui/animation/Animation.rotate.html) | 从原点顺时针旋转一个角度 |
| [Animation.rotate3d](/api/ui/animation/Animation.rotate3d.html) | 从 X 轴顺时针旋转一个角度 |
| [Animation.rotateX](/api/ui/animation/Animation.rotateX.html) | 从 X 轴顺时针旋转一个角度 |
| [Animation.rotateY](/api/ui/animation/Animation.rotateY.html) | 从 Y 轴顺时针旋转一个角度 |
| [Animation.rotateZ](/api/ui/animation/Animation.rotateZ.html) | 从 Z 轴顺时针旋转一个角度 |
| [Animation.scale](/api/ui/animation/Animation.scale.html) | 缩放 |
| [Animation.scale3d](/api/ui/animation/Animation.scale3d.html) | 缩放 |
| [Animation.scaleX](/api/ui/animation/Animation.scaleX.html) | 缩放 X 轴 |
| [Animation.scaleY](/api/ui/animation/Animation.scaleY.html) | 缩放 Y 轴 |
| [Animation.scaleZ](/api/ui/animation/Animation.scaleZ.html) | 缩放 Z 轴 |
| [Animation.skew](/api/ui/animation/Animation.skew.html) | 对 X、Y 轴坐标进行倾斜 |
| [Animation.skewX](/api/ui/animation/Animation.skewX.html) | 对 X 轴坐标进行倾斜 |
| [Animation.skewY](/api/ui/animation/Animation.skewY.html) | 对 Y 轴坐标进行倾斜 |
| [Animation.step](/api/ui/animation/Animation.step.html) | 表示一组动画完成 |
| [Animation.top](/api/ui/animation/Animation.top.html) | 设置 top 值 |
| [Animation.translate](/api/ui/animation/Animation.translate.html) | 平移变换 |
| [Animation.translate3d](/api/ui/animation/Animation.translate3d.html) | 对 xyz 坐标进行平移变换 |
| [Animation.translateX](/api/ui/animation/Animation.translateX.html) | 对 X 轴平移 |
| [Animation.translateY](/api/ui/animation/Animation.translateY.html) | 对 Y 轴平移 |
| [Animation.translateZ](/api/ui/animation/Animation.translateZ.html) | 对 Z 轴平移 |
| [Animation.width](/api/ui/animation/Animation.width.html) | 设置宽度 |
| [Animation.backgroundColor](/api/ui/animation/Animation.backgroundColor.html) | 设置背景色 |
| [Animation.bottom](/api/ui/animation/Animation.bottom.html) | 设置 bottom 值 |
| [Animation.export](/api/ui/animation/Animation.export.html) | 导出动画队列 |


### 自定义组件

| 名称                                                     | 功能说明                           |
| -------------------------------------------------------- | ---------------------------------- |
| [qa.nextTick](/api/ui/custom-component/qa.nextTick.html) | 延迟一部分操作到下一个时间片再执行 |

### 菜单

| 名称 | 功能说明 |
| --- | --- |
| [qa.getMenuButtonBoundingClientRect](/api/ui/menu/qa.getMenuButtonBoundingClientRect.html) | 获取菜单按钮（右上角menu按钮）的布局位置信息 |

## 网络

### 发起请求

| 名称                                               | 功能说明            |
| -------------------------------------------------- | ------------------- |
| [qa.request](/api/network/request/qa.request.html) | 发起 HTTPS 网络请求的接口 |

#### RequestTask

| 名称                                                             | 功能说明     |
| ---------------------------------------------------------------- | ------------ |
| [RequestTask.abort](/api/network/request/RequestTask.abort.html) | 中断该请求任务 |

### 下载

| 名称                                                          | 功能说明           |
| ------------------------------------------------------------- | ------------------ |
| [qa.downloadFile](/api/network/download/qa.downloadFile.html) | 下载文件资源到本地的接口 |

#### DownloadTask

| 名称 | 功能说明 |
| --- | --- |
| [DownloadTask.abort](/api/network/download/DownloadTask.abort.html) | 中断进行中的下载任务 |
| [DownloadTask.offProgressUpdate](/api/network/download/DownloadTask.offProgressUpdate.html) | 取消订阅**下载进度变化事件** |
| [DownloadTask.onProgressUpdate](/api/network/download/DownloadTask.onProgressUpdate.html) | 订阅**下载进度变化事件**事件 |

### 上传

| 名称                                                    | 功能说明               |
| ------------------------------------------------------- | ---------------------- |
| [qa.uploadFile](/api/network/upload/qa.uploadFile.html) | 将本地文件上传到服务器端 |

#### UploadTask

| 名称                                                                                  | 功能说明                 |
| ------------------------------------------------------------------------------------- | ------------------------ |
| [UploadTask.abort](/api/network/upload/UploadTask.abort.html)                         | 中断该上传任务             |
| [UploadTask.offProgressUpdate](/api/network/upload/UploadTask.offProgressUpdate.html) | 取消订阅**上传进度变化事件** |
| [UploadTask.onProgressUpdate](/api/network/upload/UploadTask.onProgressUpdate.html)   | 订阅**上传进度变化事件**回调 |

### WebSocket

| 名称                                                                     | 功能说明                              |
| ------------------------------------------------------------------------ | ------------------------------------- |
| [qa.sendSocketMessage](/api/network/websocket/qa.sendSocketMessage.html) | 通过已连接成功的WebSocket连接发送数据   |
| [qa.onSocketOpen](/api/network/websocket/qa.onSocketOpen.html)           | 订阅**WebSocket连接打开事件**回调           |
| [qa.onSocketMessage](/api/network/websocket/qa.onSocketMessage.html)     | 订阅**WebSocket接受到服务器的消息事件**回调 |
| [qa.onSocketError](/api/network/websocket/qa.onSocketError.html)         | 订阅**WebSocket错误事件**回调               |
| [qa.onSocketClose](/api/network/websocket/qa.onSocketClose.html)         | 订阅**WebSocket连接关闭事件**回调           |
| [qa.connectSocket](/api/network/websocket/qa.connectSocket.html)         | 创建新的WebSocket连接               |
| [qa.closeSocket](/api/network/websocket/qa.closeSocket.html)             | 关闭WebSocket连接                   |

#### SocketTask

| 名称                                                                     | 功能说明                              |
| ------------------------------------------------------------------------ | ------------------------------------- |
| [SocketTask.close](/api/network/websocket/SocketTask.close.html)         | 关闭当前WebSocket连接                   |
| [SocketTask.onClose](/api/network/websocket/SocketTask.onClose.html)     | 订阅**WebSocket连接关闭事件**回调           |
| [SocketTask.onError](/api/network/websocket/SocketTask.onError.html)     | 订阅**WebSocket错误事件**回调               |
| [SocketTask.onMessage](/api/network/websocket/SocketTask.onMessage.html) | 订阅**WebSocket接受到服务器的消息事件**回调 |
| [SocketTask.onOpen](/api/network/websocket/SocketTask.onOpen.html)       | 订阅**WebSocket连接打开事件**回调           |
| [SocketTask.send](/api/network/websocket/SocketTask.send.html)           | 通过已创建的WebSocket连接发送数据           |

## 数据缓存

| 名称 | 功能说明 |
| --- | --- |
| [qa.setStorageSync](/api/storage/qa.setStorageSync.html) | [qa.setStorage](/api/storage/qa.setStorage.html) 的同步版本 |
| [qa.setStorage](/api/storage/qa.setStorage.html) | 将数据存储在本地缓存中指定的 key 中 |
| [qa.removeStorageSync](/api/storage/qa.removeStorageSync.html) | [qa.removeStorage](/api/storage/qa.removeStorage.html) 的同步版本 |
| [qa.removeStorage](/api/storage/qa.removeStorage.html) | 从本地缓存中移除指定 key |
| [qa.getStorageSync](/api/storage/qa.getStorageSync.html) | [qa.getStorage](/api/storage/qa.getStorage.html) 的同步版本 |
| [qa.getStorageInfoSync](/api/storage/qa.getStorageInfoSync.html) | [qa.getStorageInfo](/api/storage/qa.getStorageInfo.html) 的同步版本 |
| [qa.getStorageInfo](/api/storage/qa.getStorageInfo.html) | 异步获取当前 storage 的相关信息 |
| [qa.getStorage](/api/storage/qa.getStorage.html) | 从本地缓存中异步获取指定 key 的内容 |
| [qa.clearStorageSync](/api/storage/qa.clearStorageSync.html) | [qa.clearStorage](/api/storage/qa.clearStorage.html) 的同步版本 |
| [qa.clearStorage](/api/storage/qa.clearStorage.html) | 清理本地数据缓存 |

## 媒体

### 地图

| 名称 | 功能说明 |
| --- | --- |
| [qa.createMapContext](/api/media/map/qa.createMapContext.html) | 创建 [map](/api/../component/map.html) 上下文 [MapContext](/api/media/map/MapContext.html) 对象 |

#### MapContext

| 名称                                                                             | 功能说明                   |
| -------------------------------------------------------------------------------- | -------------------------- |
| [MapContext.getCenterLocation](/api/media/map/MapContext.getCenterLocation.html) | 获取当前地图中心的经纬度   |
| [MapContext.getRegion](/api/media/map/MapContext.getRegion.html)                 | 获取当前地图的视野范围     |
| [MapContext.getScale](/api/media/map/MapContext.getScale.html)                   | 获取当前地图的缩放级别     |
| [MapContext.includePoints](/api/media/map/MapContext.includePoints.html)         | 缩放视野展示所有经纬度     |
| [MapContext.moveToLocation](/api/media/map/MapContext.moveToLocation.html)       | 将地图中心移动到当前定位点 |
| [MapContext.translateMarker](/api/media/map/MapContext.translateMarker.html)     | 平移 marker，带动画        |

### 图片

| 名称                                                                         | 功能说明                         |
| ---------------------------------------------------------------------------- | -------------------------------- |
| [qa.saveImageToPhotosAlbum](/api/media/image/qa.saveImageToPhotosAlbum.html) | 保存图片到系统相册               |
| [qa.previewImage](/api/media/image/qa.previewImage.html)                     | 在新页面中全屏预览图片           |
| [qa.getImageInfo](/api/media/image/qa.getImageInfo.html)                     | 获取图片信息                     |
| [qa.compressImage](/api/media/image/qa.compressImage.html)                   | 压缩图片接口，可选压缩质量       |
| [qa.chooseImage](/api/media/image/qa.chooseImage.html)                       | 从本地相册选择图片或使用相机拍照 |

### 视频

| 名称 | 功能说明 |
| --- | --- |
| [qa.saveVideoToPhotosAlbum](/api/media/video/qa.saveVideoToPhotosAlbum.html) | 保存视频到系统相册 |
| [qa.createVideoContext](/api/media/video/qa.createVideoContext.html) | 创建 [video](/api/../component/video.html) 上下文 [VideoContext](/api/media/video/VideoContext.html) 对象 |
| [qa.chooseVideo](/api/media/video/qa.chooseVideo.html) | 拍摄视频或从手机相册中选视频 |

#### VideoContext

| 名称                                                                                   | 功能说明       |
| -------------------------------------------------------------------------------------- | -------------- |
| [VideoContext.exitFullScreen](/api/media/video/VideoContext.exitFullScreen.html)       | 退出全屏       |
| [VideoContext.pause](/api/media/video/VideoContext.pause.html)                         | 暂停视频       |
| [VideoContext.play](/api/media/video/VideoContext.play.html)                           | 播放视频       |
| [VideoContext.requestFullScreen](/api/media/video/VideoContext.requestFullScreen.html) | 进入全屏       |
| [VideoContext.seek](/api/media/video/VideoContext.seek.html)                           | 跳转到指定位置 |
| [VideoContext.stop](/api/media/video/VideoContext.stop.html)                           | 停止视频       |

### 音频

| 名称 | 功能说明 |
| --- | --- |
| [qa.setInnerAudioOption](/api/media/audio/qa.setInnerAudioOption.html) | 设置 [InnerAudioContext](/api/media/audio/InnerAudioContext.html) 的播放选项 |
| [qa.createInnerAudioContext](/api/media/audio/qa.createInnerAudioContext.html) | 创建用于音频播放 [audio](../../../component/audio.html) 的上下文 [InnerAudioContext](/api/media/audio/InnerAudioContext.html) 对象 |

#### InnerAudioContext

| 名称 | 功能说明 |
| --- | --- |
| [InnerAudioContext.destroy](/api/media/audio/InnerAudioContext.destroy.html) | 销毁当前InnerAudioContext实例 |
| [InnerAudioContext.offCanplay](/api/media/audio/InnerAudioContext.offCanplay.html) | 取消订阅**音频进入可以播放状态事件** |
| [InnerAudioContext.offEnded](/api/media/audio/InnerAudioContext.offEnded.html) | 取消订阅**音频自然播放至结束的事件** |
| [InnerAudioContext.offError](/api/media/audio/InnerAudioContext.offError.html) | 取消订阅**音频播放错误事件** |
| [InnerAudioContext.offPause](/api/media/audio/InnerAudioContext.offPause.html) | 取消订阅**音频暂停事件** |
| [InnerAudioContext.offPlay](/api/media/audio/InnerAudioContext.offPlay.html) | 取消订阅**音频播放事件** |
| [InnerAudioContext.offSeeked](/api/media/audio/InnerAudioContext.offSeeked.html) | 取消订阅**音频完成跳转操作的事件** |
| [InnerAudioContext.offSeeking](/api/media/audio/InnerAudioContext.offSeeking.html) | 取消订阅**音频进行跳转操作的事件** |
| [InnerAudioContext.offStop](/api/media/audio/InnerAudioContext.offStop.html) | 取消订阅**音频停止事件** |
| [InnerAudioContext.offTimeUpdate](/api/media/audio/InnerAudioContext.offTimeUpdate.html) | 取消订阅**音频播放进度更新事件** |
| [InnerAudioContext.offWaiting](/api/media/audio/InnerAudioContext.offWaiting.html) | 取消订阅**音频加载中事件** |
| [InnerAudioContext.onCanplay](/api/media/audio/InnerAudioContext.onCanplay.html) | 订阅**音频进入可以播放状态的事件**回调 |
| [InnerAudioContext.onEnded](/api/media/audio/InnerAudioContext.onEnded.html) | 订阅**音频自然播放至结束的事件**回调 |
| [InnerAudioContext.onError](/api/media/audio/InnerAudioContext.onError.html) | 订阅**音频播放错误事件**回调 |
| [InnerAudioContext.onPause](/api/media/audio/InnerAudioContext.onPause.html) | 订阅**音频暂停事件**回调 |
| [InnerAudioContext.onPlay](/api/media/audio/InnerAudioContext.onPlay.html) | 订阅**音频播放事件**回调 |
| [InnerAudioContext.onSeeked](/api/media/audio/InnerAudioContext.onSeeked.html) | 订阅**音频完成跳转操作的事件**回调 |
| [InnerAudioContext.onSeeking](/api/media/audio/InnerAudioContext.onSeeking.html) | 订阅**音频进行跳转操作的事件**回调 |
| [InnerAudioContext.onStop](/api/media/audio/InnerAudioContext.onStop.html) | 订阅**音频停止事件**回调 |
| [InnerAudioContext.onTimeUpdate](/api/media/audio/InnerAudioContext.onTimeUpdate.html) | 订阅**音频播放进度更新事件**回调 |
| [InnerAudioContext.onWaiting](/api/media/audio/InnerAudioContext.onWaiting.html) | 订阅**音频加载中事件**回调 |
| [InnerAudioContext.pause](/api/media/audio/InnerAudioContext.pause.html) | 暂停播放音频 |
| [InnerAudioContext.play](/api/media/audio/InnerAudioContext.play.html) | 播放音频 |
| [InnerAudioContext.seek](/api/media/audio/InnerAudioContext.seek.html) | 跳转到该音频的指定位置 |
| [InnerAudioContext.stop](/api/media/audio/InnerAudioContext.stop.html) | 停止播放音频 |

### 背景音频

| 名称 | 功能说明 |
| --- | --- |
| [qa.stopBackgroundAudio](/api/media/background-audio/qa.stopBackgroundAudio.html) | 停止播放音乐 |
| [qa.seekBackgroundAudio](/api/media/background-audio/qa.seekBackgroundAudio.html) | 控制音乐播放进度 |
| [qa.playBackgroundAudio](/api/media/background-audio/qa.playBackgroundAudio.html) | 使用后台播放器播放音乐 |
| [qa.pauseBackgroundAudio](/api/media/background-audio/qa.pauseBackgroundAudio.html) | 暂停播放音乐 |
| [qa.onBackgroundAudioStop](/api/media/background-audio/qa.onBackgroundAudioStop.html) | 监听音乐停止事件 |
| [qa.onBackgroundAudioPlay](/api/media/background-audio/qa.onBackgroundAudioPlay.html) | 监听音乐播放事件 |
| [qa.onBackgroundAudioPause](/api/media/background-audio/qa.onBackgroundAudioPause.html) | 监听音乐暂停事件 |
| [qa.getBackgroundAudioPlayerState](/api/media/background-audio/qa.getBackgroundAudioPlayerState.html) | 获取后台音乐播放状态 |
| [qa.getBackgroundAudioManager](/api/media/background-audio/qa.getBackgroundAudioManager.html) | 获取**全局唯一**的背景音频管理器 |

#### BackgroundAudioManager

| 名称 | 功能说明 |
| --- | --- |
| [BackgroundAudioManager.onPlay](/api/media/background-audio/BackgroundAudioManager.onPlay.html) | 监听背景音频播放事件 |
| [BackgroundAudioManager.onSeeked](/api/media/background-audio/BackgroundAudioManager.onSeeked.html) | 监听背景音频完成跳转操作事件 |
| [BackgroundAudioManager.onSeeking](/api/media/background-audio/BackgroundAudioManager.onSeeking.html) | 监听背景音频开始跳转操作事件 |
| [BackgroundAudioManager.onStop](/api/media/background-audio/BackgroundAudioManager.onStop.html) | 监听背景音频停止事件 |
| [BackgroundAudioManager.onTimeUpdate](/api/media/background-audio/BackgroundAudioManager.onTimeUpdate.html) | 监听背景音频播放进度更新事件，只有快应用在前台时会回调 |
| [BackgroundAudioManager.onWaiting](/api/media/background-audio/BackgroundAudioManager.onWaiting.html) | 监听音频加载中事件 |
| [BackgroundAudioManager.pause](/api/media/background-audio/BackgroundAudioManager.pause.html) | 暂停音乐 |
| [BackgroundAudioManager.play](/api/media/background-audio/BackgroundAudioManager.play.html) | 播放音乐 |
| [BackgroundAudioManager.seek](/api/media/background-audio/BackgroundAudioManager.seek.html) | 跳转到指定位置 |
| [BackgroundAudioManager.stop](/api/media/background-audio/BackgroundAudioManager.stop.html) | 停止音乐 |
| [BackgroundAudioManager.onCanplay](/api/media/background-audio/BackgroundAudioManager.onCanplay.html) | 监听背景音频进入可播放状态事件 |
| [BackgroundAudioManager.onEnded](/api/media/background-audio/BackgroundAudioManager.onEnded.html) | 监听背景音频自然播放结束事件 |
| [BackgroundAudioManager.onError](/api/media/background-audio/BackgroundAudioManager.onError.html) | 监听背景音频播放错误事件 |
| [BackgroundAudioManager.onPause](/api/media/background-audio/BackgroundAudioManager.onPause.html) | 监听背景音频暂停事件 |

### 录音

| 名称 | 功能说明 |
| --- | --- |
| [qa.stopRecord](/api/media/recorder/qa.stopRecord.html) | 停止录音 |
| [qa.startRecord](/api/media/recorder/qa.startRecord.html) | 开始录音 |
| [qa.getRecorderManager](/api/media/recorder/qa.getRecorderManager.html) | 获取**全局唯一**的录音管理器 RecorderManager |

#### RecorderManager

| 名称                                                                          | 功能说明         |
| ----------------------------------------------------------------------------- | ---------------- |
| [RecorderManager.onError](/api/media/recorder/RecorderManager.onError.html)   | 订阅**录音错误事件**回调 |
| [RecorderManager.onPause](/api/media/recorder/RecorderManager.onPause.html)   | 订阅**录音暂停事件**回调（只支持 Android 7.0 及以上设备） |
| [RecorderManager.onResume](/api/media/recorder/RecorderManager.onResume.html) | 订阅**录音继续事件**回调（只支持 Android 7.0 及以上设备） |
| [RecorderManager.onStart](/api/media/recorder/RecorderManager.onStart.html)   | 订阅**录音开始事件**回调 |
| [RecorderManager.onStop](/api/media/recorder/RecorderManager.onStop.html)     | 订阅**录音结束事件**回调 |
| [RecorderManager.pause](/api/media/recorder/RecorderManager.pause.html)       | 暂停录音 （只支持 Android 7.0 及以上设备）         |
| [RecorderManager.resume](/api/media/recorder/RecorderManager.resume.html)     | 继续录音 （只支持 Android 7.0 及以上设备）         |
| [RecorderManager.start](/api/media/recorder/RecorderManager.start.html)       | 开始录音         |
| [RecorderManager.stop](/api/media/recorder/RecorderManager.stop.html)         | 停止录音         |

## 位置

| 名称                                                      | 功能说明                   |
| --------------------------------------------------------- | -------------------------- |
| [qa.openLocation](/api/location/qa.openLocation.html)     | 使用快应用内置地图查看位置 |
| [qa.getLocation](/api/location/qa.getLocation.html)       | 获取当前的地理位置、速度   |
| [qa.chooseLocation](/api/location/qa.chooseLocation.html) | 打开地图选择位置           |

## 画布

| 名称 | 功能说明 |
| --- | --- |
| [qa.createCanvasContext](/api/canvas/qa.createCanvasContext.html) | 创建 canvas 的绘图上下文 [CanvasContext](/api/canvas/CanvasContext.html) 对象 |
| [qa.canvasPutImageData](/api/canvas/qa.canvasPutImageData.html) | 将像素数据绘制到画布 |
| [qa.canvasGetImageData](/api/canvas/qa.canvasGetImageData.html) | 获取 canvas 区域隐含的像素数据 |

### CanvasContext

| 名称 | 功能说明 |
| --- | --- |
| [CanvasContext.arc](/api/canvas/CanvasContext.arc.html) | 创建一条弧线 |
| [CanvasContext.arcTo](/api/canvas/CanvasContext.arcTo.html) | 根据控制点和半径绘制圆弧路径 |
| [CanvasContext.beginPath](/api/canvas/CanvasContext.beginPath.html) | 开始创建一个路径 |
| [CanvasContext.bezierCurveTo](/api/canvas/CanvasContext.bezierCurveTo.html) | 创建三次方贝塞尔曲线路径 |
| [CanvasContext.clearRect](/api/canvas/CanvasContext.clearRect.html) | 清除画布上在该矩形区域内的内容 |
| [CanvasContext.clip](/api/canvas/CanvasContext.clip.html) | 从原始画布中剪切任意形状和尺寸 |
| [CanvasContext.closePath](/api/canvas/CanvasContext.closePath.html) | 关闭一个路径 |
| [CanvasContext.createCircularGradient](/api/canvas/CanvasContext.createCircularGradient.html) | 创建一个圆形的渐变颜色 |
| [CanvasContext.createLinearGradient](/api/canvas/CanvasContext.createLinearGradient.html) | 创建一个线性的渐变颜色 |
| [CanvasContext.createPattern](/api/canvas/CanvasContext.createPattern.html) | 对指定的图像创建模式的方法，可在指定的方向上重复元图像 |
| [CanvasContext.draw](/api/canvas/CanvasContext.draw.html) | 将之前在绘图上下文中的描述（路径、变形、样式）画到 canvas 中 |
| [CanvasContext.drawImage](/api/canvas/CanvasContext.drawImage.html) | 绘制图像到画布 |
| [CanvasContext.fill](/api/canvas/CanvasContext.fill.html) | 对当前路径中的内容进行填充 |
| [CanvasContext.fillRect](/api/canvas/CanvasContext.fillRect.html) | 填充一个矩形 |
| [CanvasContext.fillText](/api/canvas/CanvasContext.fillText.html) | 在画布上绘制被填充的文本 |
| [CanvasContext.lineTo](/api/canvas/CanvasContext.lineTo.html) | 增加一个新点，然后创建一条从上次指定点到目标点的线 |
| [CanvasContext.measureText](/api/canvas/CanvasContext.measureText.html) | 测量文本尺寸信息 |
| [CanvasContext.moveTo](/api/canvas/CanvasContext.moveTo.html) | 把路径移动到画布中的指定点，不创建线条 |
| [CanvasContext.quadraticCurveTo](/api/canvas/CanvasContext.quadraticCurveTo.html) | 创建二次贝塞尔曲线路径 |
| [CanvasContext.rect](/api/canvas/CanvasContext.rect.html) | 创建一个矩形路径 |
| [CanvasContext.restore](/api/canvas/CanvasContext.restore.html) | 恢复之前保存的绘图上下文 |
| [CanvasContext.rotate](/api/canvas/CanvasContext.rotate.html) | 以原点为中心顺时针旋转当前坐标轴 |
| [CanvasContext.save](/api/canvas/CanvasContext.save.html) | 保存绘图上下文 |
| [CanvasContext.scale](/api/canvas/CanvasContext.scale.html) | 在调用后，之后创建的路径其横纵坐标会被缩放 |
| [CanvasContext.setFillStyle](/api/canvas/CanvasContext.setFillStyle.html) | 设置填充色 |
| [CanvasContext.setFontSize](/api/canvas/CanvasContext.setFontSize.html) | 设置字体的字号 |
| [CanvasContext.setGlobalAlpha](/api/canvas/CanvasContext.setGlobalAlpha.html) | 设置全局画笔透明度 |
| [CanvasContext.setLineCap](/api/canvas/CanvasContext.setLineCap.html) | 设置线条的端点样式 |
| [CanvasContext.setLineDash](/api/canvas/CanvasContext.setLineDash.html) | 设置虚线样式 |
| [CanvasContext.setLineJoin](/api/canvas/CanvasContext.setLineJoin.html) | 设置线条的交点样式 |
| [CanvasContext.setLineWidth](/api/canvas/CanvasContext.setLineWidth.html) | 设置线条的宽度 |
| [CanvasContext.setMiterLimit](/api/canvas/CanvasContext.setMiterLimit.html) | 设置最大斜接长度 |
| [CanvasContext.setStrokeStyle](/api/canvas/CanvasContext.setStrokeStyle.html) | 设置描边颜色 |
| [CanvasContext.setTextAlign](/api/canvas/CanvasContext.setTextAlign.html) | 设置文字的对齐 |
| [CanvasContext.setTextBaseline](/api/canvas/CanvasContext.setTextBaseline.html) | 设置文字的竖直对齐 |
| [CanvasContext.setTransform](/api/canvas/CanvasContext.setTransform.html) | 使用矩阵重新设置（覆盖）当前变换的方法 |
| [CanvasContext.stroke](/api/canvas/CanvasContext.stroke.html) | 画出当前路径的边框 |
| [CanvasContext.strokeRect](/api/canvas/CanvasContext.strokeRect.html) | 画一个矩形(非填充) |
| [CanvasContext.strokeText](/api/canvas/CanvasContext.strokeText.html) | 给定的 (x, y) 位置绘制文本描边的方法 |
| [CanvasContext.transform](/api/canvas/CanvasContext.transform.html) | 使用矩阵多次叠加当前变换的方法 |
| [CanvasContext.translate](/api/canvas/CanvasContext.translate.html) | 对当前坐标系的原点 (0, 0) 进行变换 |

### CanvasGradient

| 名称                                                                        | 功能说明         |
| --------------------------------------------------------------------------- | ---------------- |
| [CanvasGradient.addColorStop](/api/canvas/CanvasGradient.addColorStop.html) | 添加颜色的渐变点 |
| [Image](/api/canvas/Image.html)                                             | 图片对象         |

## 文件

| 名称                                                      | 功能说明                               |
| --------------------------------------------------------- | -------------------------------------- |
| [qa.saveFile](/api/file/qa.saveFile.html)                 | 保存文件到本地                         |
| [qa.removeSavedFile](/api/file/qa.removeSavedFile.html)   | 删除本地缓存文件                       |
| [qa.openDocument](/api/file/qa.openDocument.html)         | 新开页面打开文档                       |
| [qa.getSavedFileList](/api/file/qa.getSavedFileList.html) | 获取该快应用下已保存的本地缓存文件列表 |
| [qa.getSavedFileInfo](/api/file/qa.getSavedFileInfo.html) | 获取本地文件的文件信息                 |
| [qa.getFileInfo](/api/file/qa.getFileInfo.html)           | 获取文件信息                           |

## 开放接口

### alipay

| 名称                                                                   | 功能说明           |
| ---------------------------------------------------------------------- | ------------------ |
| [qa.requestAliPayment](/api/open-api/alipay/qa.requestAliPayment.html) | 使用支付宝完成支付 |

### 登录

| 名称                                                        | 功能说明                     |
| ----------------------------------------------------------- | ---------------------------- |
| [qa.login](/api/open-api/login/qa.login.html)               | 调用接口获取登录凭证（code） |

### 快应用跳转

| 名称                                                                                       | 功能说明           |
| ------------------------------------------------------------------------------------------ | ------------------ |
| [qa.navigateToQuickapp](/api/open-api/quickapp-navigate/qa.navigateToQuickapp.html)   | 打开另一个快应用   |
| [qa.navigateBackQuickapp](/api/open-api/quickapp-navigate/qa.navigateBackQuickapp.html) | 返回到上一个快应用 |

### 用户信息

| 名称                                                          | 功能说明     |
| ------------------------------------------------------------- | ------------ |
| [qa.getUserInfo](/api/open-api/user-info/qa.getUserInfo.html) | 获取用户信息 |

### 授权

| 名称                                                      | 功能说明               |
| --------------------------------------------------------- | ---------------------- |
| [qa.authorize](/api/open-api/authorize/qa.authorize.html) | 提前向用户发起授权请求 |

### 设置

| 名称 | 功能说明 |
| --- | --- |
| [qa.getSetting](/api/open-api/setting/qa.getSetting.html) | 获取用户的当前设置 |
| [AuthSetting](/api/open-api/setting/AuthSetting.html) | 用户授权设置信息，详情参考[权限](/api/../framework/open-ability/authorize.html) |

### vendorpay

| 名称 | 功能说明 |
| --- | --- |
| [qa.getVendorPaymentProvider](/api/open-api/vendorpay/qa.getVendorPaymentProvider.html) | 获取服务提供商，同步接口 |
| [qa.requestVendorPayment](/api/open-api/vendorpay/qa.requestVendorPayment.html) | 使用设备商提供的支付完成付款 |

### wxpay

| 名称                                                                | 功能说明                       |
| ------------------------------------------------------------------- | ------------------------------ |
| [qa.getWxPaymentType](/api/open-api/wxpay/qa.getWxPaymentType.html) | 获取当前可用的微信支付调用方式 |
| [qa.requestWxPayment](/api/open-api/wxpay/qa.requestWxPayment.html) | 发起微信支付                   |

## 设备

### Wi-Fi

| 名称                                                             | 功能说明                      |
| ---------------------------------------------------------------- | ----------------------------- |
| [qa.stopWifi](/api/device/wifi/qa.stopWifi.html)                 | 关闭 Wi-Fi 模块               |
| [qa.startWifi](/api/device/wifi/qa.startWifi.html)               | 初始化 Wi-Fi 模块             |
| [qa.onWifiConnected](/api/device/wifi/qa.onWifiConnected.html)   | 监听连接上 Wi-Fi 的事件       |
| [qa.onGetWifiList](/api/device/wifi/qa.onGetWifiList.html)       | 监听获取到 Wi-Fi 列表数据事件 |
| [qa.getWifiList](/api/device/wifi/qa.getWifiList.html)           | 请求获取 Wi-Fi 列表           |
| [qa.getConnectedWifi](/api/device/wifi/qa.getConnectedWifi.html) | 获取已连接中的 Wi-Fi 信息     |
| [qa.connectWifi](/api/device/wifi/qa.connectWifi.html)           | 连接 Wi-Fi                    |
| [WifiInfo](/api/device/wifi/WifiInfo.html)                       | Wifi 信息                     |

### 低功耗蓝牙

| 名称 | 功能说明 |
| --- | --- |
| [qa.readBLECharacteristicValue](/api/device/bluetooth-ble/qa.readBLECharacteristicValue.html) | 读取低功耗蓝牙设备的特征值的二进制数据值 |
| [qa.onBLEConnectionStateChange](/api/device/bluetooth-ble/qa.onBLEConnectionStateChange.html) | 监听低功耗蓝牙连接状态的改变事件 |
| [qa.onBLECharacteristicValueChange](/api/device/bluetooth-ble/qa.onBLECharacteristicValueChange.html) | 监听低功耗蓝牙设备的特征值变化事件 |
| [qa.notifyBLECharacteristicValueChange](/api/device/bluetooth-ble/qa.notifyBLECharacteristicValueChange.html) | 启用低功耗蓝牙设备特征值变化时的 notify 功能，订阅特征值 |
| [qa.getBLEDeviceServices](/api/device/bluetooth-ble/qa.getBLEDeviceServices.html) | 获取蓝牙设备所有服务(service) |
| [qa.getBLEDeviceCharacteristics](/api/device/bluetooth-ble/qa.getBLEDeviceCharacteristics.html) | 获取蓝牙设备某个服务中所有特征值(characteristic) |
| [qa.createBLEConnection](/api/device/bluetooth-ble/qa.createBLEConnection.html) | 连接低功耗蓝牙设备 |
| [qa.closeBLEConnection](/api/device/bluetooth-ble/qa.closeBLEConnection.html) | 断开与低功耗蓝牙设备的连接 |
| [qa.writeBLECharacteristicValue](/api/device/bluetooth-ble/qa.writeBLECharacteristicValue.html) | 向低功耗蓝牙设备特征值中写入二进制数据 |

### 联系人

| 名称                                                              | 功能说明             |
| ----------------------------------------------------------------- | -------------------- |
| [qa.addPhoneContact](/api/device/contact/qa.addPhoneContact.html) | 添加手机通讯录联系人 |

### 蓝牙

| 名称 | 功能说明 |
| --- | --- |
| [qa.stopBluetoothDevicesDiscovery](/api/device/bluetooth/qa.stopBluetoothDevicesDiscovery.html) | 停止搜寻附近的蓝牙外围设备 |
| [qa.startBluetoothDevicesDiscovery](/api/device/bluetooth/qa.startBluetoothDevicesDiscovery.html) | 开始搜寻附近的蓝牙外围设备 |
| [qa.openBluetoothAdapter](/api/device/bluetooth/qa.openBluetoothAdapter.html) | 初始化蓝牙模块 |
| [qa.onBluetoothDeviceFound](/api/device/bluetooth/qa.onBluetoothDeviceFound.html) | 监听寻找到新设备的事件 |
| [qa.onBluetoothAdapterStateChange](/api/device/bluetooth/qa.onBluetoothAdapterStateChange.html) | 监听蓝牙适配器状态变化事件 |
| [qa.getConnectedBluetoothDevices](/api/device/bluetooth/qa.getConnectedBluetoothDevices.html) | 根据 uuid 获取处于已连接状态的设备 |
| [qa.getBluetoothDevices](/api/device/bluetooth/qa.getBluetoothDevices.html) | 获取在蓝牙模块生效期间所有已发现的蓝牙设备 |
| [qa.getBluetoothAdapterState](/api/device/bluetooth/qa.getBluetoothAdapterState.html) | 获取本机蓝牙适配器状态 |
| [qa.closeBluetoothAdapter](/api/device/bluetooth/qa.closeBluetoothAdapter.html) | 关闭蓝牙模块 |

### 电量

| 名称 | 功能说明 |
| --- | --- |
| [qa.getBatteryInfoSync](/api/device/battery/qa.getBatteryInfoSync.html) | [qa.getBatteryInfo](/api/device/battery/qa.getBatteryInfo.html) 的同步版本 |
| [qa.getBatteryInfo](/api/device/battery/qa.getBatteryInfo.html) | 获取设备电量 |

### 剪贴板

| 名称                                                                  | 功能说明             |
| --------------------------------------------------------------------- | -------------------- |
| [qa.setClipboardData](/api/device/clipboard/qa.setClipboardData.html) | 设置系统剪贴板的内容 |
| [qa.getClipboardData](/api/device/clipboard/qa.getClipboardData.html) | 获取系统剪贴板的内容 |

### 网络

| 名称                                                                          | 功能说明             |
| ----------------------------------------------------------------------------- | -------------------- |
| [qa.onNetworkStatusChange](/api/device/network/qa.onNetworkStatusChange.html) | 监听网络状态变化事件 |
| [qa.getNetworkType](/api/device/network/qa.getNetworkType.html)               | 获取网络类型         |

### 屏幕

| 名称                                                                     | 功能说明             |
| ------------------------------------------------------------------------ | -------------------- |
| [qa.setScreenBrightness](/api/device/screen/qa.setScreenBrightness.html) | 设置屏幕亮度         |
| [qa.setKeepScreenOn](/api/device/screen/qa.setKeepScreenOn.html)         | 设置是否保持常亮状态 |
| [qa.onUserCaptureScreen](/api/device/screen/qa.onUserCaptureScreen.html) | 监听用户主动截屏事件 |
| [qa.getScreenBrightness](/api/device/screen/qa.getScreenBrightness.html) | 获取屏幕亮度         |

### 电话

| 名称                                                        | 功能说明 |
| ----------------------------------------------------------- | -------- |
| [qa.makePhoneCall](/api/device/phone/qa.makePhoneCall.html) | 拨打电话 |

### 加速计

| 名称                                                                                | 功能说明           |
| ----------------------------------------------------------------------------------- | ------------------ |
| [qa.stopAccelerometer](/api/device/accelerometer/qa.stopAccelerometer.html)         | 关闭加速度计监听器 |
| [qa.startAccelerometer](/api/device/accelerometer/qa.startAccelerometer.html)       | 启动监听加速度计数据 |
| [qa.onAccelerometerChange](/api/device/accelerometer/qa.onAccelerometerChange.html) | 注册加速度数据回调监听器 |

### 罗盘

| 名称                                                              | 功能说明             |
| ----------------------------------------------------------------- | -------------------- |
| [qa.stopCompass](/api/device/compass/qa.stopCompass.html)         | 关闭罗盘监听器     |
| [qa.startCompass](/api/device/compass/qa.startCompass.html)       | 启动监听罗盘数据     |
| [qa.onCompassChange](/api/device/compass/qa.onCompassChange.html) | 注册罗盘数据回调监听器 |

### 设备方向

| 名称                                                                                   | 功能说明               |
| -------------------------------------------------------------------------------------- | ---------------------- |
| [qa.stopDeviceMotionListening](/api/device/motion/qa.stopDeviceMotionListening.html)   | 关闭设备方向监听器 |
| [qa.startDeviceMotionListening](/api/device/motion/qa.startDeviceMotionListening.html) | 启动监听设备方向数据 |
| [qa.onDeviceMotionChange](/api/device/motion/qa.onDeviceMotionChange.html)             | 注册设备方向变化数据回调监听器   |

### 陀螺仪

| 名称                                                                    | 功能说明               |
| ----------------------------------------------------------------------- | ---------------------- |
| [qa.stopGyroscope](/api/device/gyroscope/qa.stopGyroscope.html)         | 关闭陀螺仪计监听器     |
| [qa.startGyroscope](/api/device/gyroscope/qa.startGyroscope.html)       | 启动监听陀螺仪数据     |
| [qa.onGyroscopeChange](/api/device/gyroscope/qa.onGyroscopeChange.html) | 注册陀螺仪数据回调监听器 |

### 性能

| 名称                                                                  | 功能说明             |
| --------------------------------------------------------------------- | -------------------- |
| [qa.onMemoryWarning](/api/device/performance/qa.onMemoryWarning.html) | 监听内存不足告警事件 |

### 扫码

| 名称                                             | 功能说明                   |
| ------------------------------------------------ | -------------------------- |
| [qa.scanCode](/api/device/scan/qa.scanCode.html) | 调起客户端扫码界面进行扫码 |

### 振动

| 名称                                                        | 功能说明                          |
| ----------------------------------------------------------- | --------------------------------- |
| [qa.vibrateShort](/api/device/vibrate/qa.vibrateShort.html) | 使手机发生较短时间的振动（15 ms） |
| [qa.vibrateLong](/api/device/vibrate/qa.vibrateLong.html)   | 使手机发生较长时间的振动（400 ms) |

## QXML

| 名称 | 功能说明 |
| --- | --- |
| [qa.createSelectorQuery](/api/qxml/qa.createSelectorQuery.html) | 返回一个 SelectorQuery 对象实例 |
| [qa.createIntersectionObserver](/api/qxml/qa.createIntersectionObserver.html) | 创建并返回一个 IntersectionObserver 对象实例 |

### IntersectionObserver

| 名称 | 功能说明 |
| --- | --- |
| [IntersectionObserver.disconnect](/api/qxml/IntersectionObserver.disconnect.html) | 停止监听 |
| [IntersectionObserver.observe](/api/qxml/IntersectionObserver.observe.html) | 指定目标节点并开始监听相交状态变化情况 |
| [IntersectionObserver.relativeTo](/api/qxml/IntersectionObserver.relativeTo.html) | 使用选择器指定一个节点，作为参照区域之一 |
| [IntersectionObserver.relativeToViewport](/api/qxml/IntersectionObserver.relativeToViewport.html) | 指定页面显示区域作为参照区域之一 |

### NodesRef

| 名称                                                                      | 功能说明                        |
| ------------------------------------------------------------------------- | ------------------------------- |
| [NodesRef.boundingClientRect](/api/qxml/NodesRef.boundingClientRect.html) | 添加节点的布局位置的查询请求    |
| [NodesRef.context](/api/qxml/NodesRef.context.html)                       | 添加节点的 Context 对象查询请求 |
| [NodesRef.fields](/api/qxml/NodesRef.fields.html)                         | 获取节点的相关信息              |
| [NodesRef.scrollOffset](/api/qxml/NodesRef.scrollOffset.html)             | 添加节点的滚动位置查询请求      |

### SelectorQuery

| 名称 | 功能说明 |
| --- | --- |
| [SelectorQuery.selectViewport](/api/qxml/SelectorQuery.selectViewport.html) | 选择显示区域 |
| [SelectorQuery.exec](/api/qxml/SelectorQuery.exec.html) | 执行所有的请求 |
| [SelectorQuery.in](/api/qxml/SelectorQuery.in.html) | 将选择器的选取范围更改为自定义组件 `component` 内 |
| [SelectorQuery.select](/api/qxml/SelectorQuery.select.html) | 在当前页面下选择第一个匹配选择器 `selector` 的节点 |
| [SelectorQuery.selectAll](/api/qxml/SelectorQuery.selectAll.html) | 在当前页面下选择匹配选择器 selector 的所有节点 |
