# 数据类型

QJS 语言目前共有以下几种数据类型：

- `string` ：字符串
- `number` ： 数值
- `boolean`：布尔值
- `object`：对象
- `function`：函数
- `array` : 数组
- `date`：日期
- `regexp`：正则表达式

## 判断数据类型

同 JavaScript 一致，可以用 `typeof` 、 `instanceof` 等判断类型。

## string

### 语法

string 有两种写法：

```js
'hello world'
'hello world'
```

### 属性

- `length`

> 请参考 `ES5` 标准。

### 方法

- `toString`
- `valueOf`
- `charAt`
- `charCodeAt`
- `concat`
- `indexOf`
- `lastIndexOf`
- `localeCompare`
- `match`
- `replace`
- `search`
- `slice`
- `split`
- `substring`
- `toLowerCase`
- `toLocaleLowerCase`
- `toUpperCase`
- `toLocaleUpperCase`
- `trim`

> 详细使用方法请参考 `ES5` 标准。

## number

### 语法

number 包括两种数值：整数，小数。

```js
var a = 10
var PI = 3.141592653589793
```

### 方法

- `toString`
- `toLocaleString`
- `valueOf`
- `toFixed`
- `toExponential`
- `toPrecision`

> 详细使用方法请参考 `ES5` 标准。

## boolean

### 语法

布尔值只有两个特定的值：`true` 和 `false`。

### 方法

- `toString`
- `valueOf`

> 详细使用方法请参考 `ES5` 标准。

## object

### 语法

```js
var o = {} //生成一个新的空对象

//生成一个新的非空对象
o = {
  string: 1, //object 的 key 可以是字符串
  constVar: 2, //object 的 key 也可以是符合变量定义规则的标识符
  obj: {} //object 的 value 可以是任何类型
}

//对象属性的读操作
console.log(1 === o['string'])
console.log(2 === o.constVar)

//对象属性的写操作
o['string']++
o['string'] += 10
o.constVar++
o.constVar += 10

//对象属性的读操作
console.log(12 === o['string'])
console.log(13 === o.constVar)
```

### 方法

- `toString`：返回字符串 `"[object Object]"`。

## function

### 语法

function 支持以下的定义方式：

```js
//方法 1
function a(x) {
  return x
}

//方法 2
var b = function(x) {
  return x
}
```

function 同时也支持以下的语法（匿名函数，闭包等）：

```js
var a = function(x) {
  return function() {
    return x
  }
}

var b = a(100)
console.log(100 === b())
```

### arguments

function 里面可以使用 `arguments` 关键词。

**示例代码：**

```js
var a = function() {
  console.log(3 === arguments.length)
  console.log(100 === arguments[0])
  console.log(200 === arguments[1])
  console.log(300 === arguments[2])
}
a(100, 200, 300)
```

### 属性

- `length`：返回函数的形参个数。

### 方法

- `toString`：返回字符串 `"[function Function]"`。

**示例代码：**

```js
var func = function(a, b, c) {}

console.log(3 === func.length)
console.log('[function Function]' === func.toString())
```

## array

### 语法

array 支持以下的定义方式：

```js
var a = [] //生成一个新的空数组

a = [1, '2', {}, function() {}] //生成一个新的非空数组，数组元素可以是任何类型
```

### 属性

- `length`

> 具体含义请参考 `ES5` 标准。

### 方法

- `toString`
- `concat`
- `join`
- `pop`
- `push`
- `reverse`
- `shift`
- `slice`
- `sort`
- `splice`
- `unshift`
- `indexOf`
- `lastIndexOf`
- `every`
- `some`
- `forEach`
- `map`
- `filter`
- `reduce`
- `reduceRight`

> 详细使用方法请参考 `ES5` 标准。

## date

### 语法

可以使用 getDate 函数, 返回一个时间对象。

```js
getDate()
getDate(value) // value 一个整数值，表示自1970年1月1日00:00:00 UTC 以来的毫秒数
getDate(dateString) // dateString 表示日期的字符串值
getDate(year, monthIndex [, day [, hours [, minutes [, seconds [, milliseconds]]]]])
```

请参考 JavaScript 的 `Date` 构造参数

### 方法

- `toString`
- `toDateString`
- `toTimeString`
- `toLocaleString`
- `toLocaleDateString`
- `toLocaleTimeString`
- `valueOf`
- `getTime`
- `getFullYear`
- `getUTCFullYear`
- `getMonth`
- `getUTCMonth`
- `getDate`
- `getUTCDate`
- `getDay`
- `getUTCDay`
- `getHours`
- `getUTCHours`
- `getMinutes`
- `getUTCMinutes`
- `getSeconds`
- `getUTCSeconds`
- `getMilliseconds`
- `getUTCMilliseconds`
- `getTimezoneOffset`
- `setTime`
- `setMilliseconds`
- `setUTCMilliseconds`
- `setSeconds`
- `setUTCSeconds`
- `setMinutes`
- `setUTCMinutes`
- `setHours`
- `setUTCHours`
- `setDate`
- `setUTCDate`
- `setMonth`
- `setUTCMonth`
- `setFullYear`
- `setUTCFullYear`
- `toUTCString`
- `toISOString`
- `toJSON`

> 详细使用方法请参考 `ES5` 标准。

## regexp

### 语法

可以使用 getRegExp 生成 regexp 对象

```js
getRegExp(pattern[, flags])
```
- pattern: 正则表达式的内容。
- flags：修饰符。可以包含以下值:
  - g: global
  - i: ignoreCase
  - m: multiline。

请参考 JavaScript 的正则表达式

### 属性

请参考 JavaScript 的正则表达式

### 方法

- `exec`
- `test`
- `toString`

> 详细使用方法请参考 `ES5` 标准。
