### App(Object object)

用于注册快应用。接受 `Object` 参数，参数中可以定义生命周期回调、全局数据、全局方法等。

#### 参数

##### Object object

| 属性 | 类型 | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| [onLaunch](#onlaunch-object-object) | function |  | 否 | 监听快应用加载。 |
| [onShow](#onshow-object-object) | function |  | 否 | 监听快应用显示，首次加载或切换到前台时触发 |
| [onHide](#onhide) | function |  | 否 | 监听快应用隐藏，切后台时触发。 |
| [onError](#onerror-string-error) | function |  | 否 | 监听未处理的报错。 |
| 其他 | any |  | 否 | 开发者可以添加任意的函数或数据变量到 `Object` 参数中，用 `this` 可以访问 |

**App() 必须在 `app.js` 中调用，必须调用且只能调用一次。**

#### 示例代码

```js
App({
  onLaunch(options) {
    // 监听快应用加载
  },
  onShow(options) {
    // 监听快应用显示
  },
  onHide() {
    // 监听快应用隐藏
  },
  onError(err) {
    console.log(err)
  },
  globalData: 'Hello QuickApp'
})
```

#### onLaunch(Object object)

快应用加载完成时触发，只触发一次。

**参数**：与 [qa.getLaunchOptionsSync](/api/base/app/qa.getLaunchOptionsSync.html) 一致

#### onShow(Object object)

快应用加载完后，或从后台切换到前台显示时触发。也可以使用 [qa.onAppShow](/api/base/app/qa.onAppShow.html) 添加监听。

**参数**：与 [qa.onAppShow](/api/base/app/qa.onAppShow.html) 一致

#### onHide()

快应用从前台切换到后台时触发。也可以使用 [qa.onAppHide](/api/base/app/qa.onAppHide.html) 添加监听。

#### onError(String error)

快应用发生未处理的报错时触发。也可以使用 [qa.onError](/api/base/app/qa.onError.html) 绑定监听。

**参数**：与 [qa.onError](/api/base/app/qa.onError.html) 一致
