# 数据监听器

数据监听器可以用于监听属性和数据的变化。

## 使用数据监听器

在 setData 一些数据字段时, 常常需要对另外一些数据做其他操作。

例如， `this.data.sum` 是 `this.data.number1` 与 `this.data.number2` 的和，当 number1 或者 number2 变动时，需要重新计算 sum 的值，这时就可以利用数据监听器实现。

```js
Component({
  attached: function() {
    this.setData({
      number1: 1,
      number2: 2,
      sum: 3
    })
  },
  observers: {
    'number1, number2': function(number1, number2) {
      // 在 number1 或者 number2 被设置时，执行这个方法
      this.setData({
        sum: number1 + number2
      })
    }
  }
})
```

## 监听字段语法

数据监听器支持监听属性或数据的变化，可以同时监听多个字段，但一次 setData 最多触发每个监听器一次。监听器也可以监听子数据字段。

代码示例：

```js
Component({
  observers: {
    'obj.filed': function(filed) {
      // 使用 setData 设置 this.data.obj.filed 时触发
      // 使用 setData 设置 this.data.obj 也会触发
      filed === this.data.obj.filed
    },
    'arr[12]': function(arr12) {
      // 使用 setData 设置 this.data.arr[12] 时触发
      // 使用 setData 设置 this.data.arr 也会触发
      arr12 === this.data.arr[12]
    }
  }
})
```

监听所有子数据字段的变化，可以使用通配符 `**` 。

```js
Component({
  observers: {
    'obj.field.**': function(field) {
      // 使用 setData 设置 this.data.obj.field 本身或其下任何子数据字段时触发
      // 使用 setData 设置 this.data.obj 也会触发
      field === this.data.obj.field
    }
  },
  attached: function() {
    // 这样会触发上面的 observer
    this.setData({
      'obj.field': {}
    })
    // 这样也会触发上面的 observer
    this.setData({
      'obj.field.xxx': {}
    })
    // 这样还是会触发上面的 observer
    this.setData({
      obj: {}
    })
  }
})
```

使用通配符 `**` 可以监听全部 setData 。

```js
Component({
  observers: {
    '**': function() {
      // 每次 setData 都会触发
    }
  }
})
```

**注意:**

::: warning

- setData 时，涉及字段的数据监听器都会触发，即使这些字段的值没有发生变化。
- 如果在数据监听器函数中使用 setData 设置本身监听的数据字段，会导致死循环，需要避免。

:::
