# 快应用代码构成

​ 一个快应用项目包含了下面四种不同类型的基本文件:

- .json 后缀的配置文件
- .qxml 后缀的模板文件
- .css 后缀的样式文件
- .js 后缀的脚本逻辑文件

## JSON 配置

JSON 是一种数据格式。在快应用中，JSON 主要用来项目的静态配置。

项目根目录有一个 `app.json` ，各页面路径下也会有 `json` 文件，我们依次来说明一下它们的用途。

### 全局配置 app.json

`app.json` 是当前快应用的全局配置，包括了快应用的所有页面路径、窗口样式、底部 tab 等。 项目里边的 `app.json` 配置内容如下：

```json
{
  "pages": ["pages/index/index", "pages/detail/detail"],
  "window": {
    "backgroundTextStyle": "light",
    "navigationBarBackgroundColor": "#fff",
    "navigationBarTitleText": "quickApp",
    "navigationBarTextStyle": "black"
  }
}
```

这几个配置项的大概含义如下:

1. `pages`字段 —— 用于定义快应用所有页面的路径。
2. `window`字段 —— 配置快应用所有页面的标题，文字颜色等。

其他配置项细节可以参考文档 [快应用的配置 app.json](./../config.html) 。

### 页面配置 page.json

这里的 `page.json` 代指各快应用页面的配置，文件名取决于各页面名。`app.json` 中定义的 `window` 配置对所有页面都起作用，如果想针对某个页面做特殊的配置，可以通过页面配置 `page.json` 。 `page.json` 中的配置项优先级高于 `app.json` 的。

其他配置项细节可以参考文档 [页面配置](./../config.html#页面配置) 。

### JSON 注意事项

- JSON 的 Key 必须包裹在一个双引号中，漏写双引号或者把双引号写成单引号都会导致报错。
- JSON 文件中无法使用注释。
- JSON 文件内容不可为空，如果没有配置项，可以保留一个 `{}`

JSON 的值只能是以下几种数据格式，其他任何格式都会触发报错，例如 undefined。

1. 数字，包含浮点数和整数
2. 字符串，需要包裹在双引号中
3. Bool 值，true 或者 false
4. 数组，需要包裹在方括号中 \[\]
5. 对象，需要包裹在大括号中 {}
6. Null

## QXML 模板

网页开发采用的是 HTML + CSS + JS 这样的组合，其中 `HTML` 是用来描述当前这个页面的结构，`CSS` 用来描述页面的样式，`JS` 用于编写页面逻辑和交互。

快应用中也是类似的，不同的是，快应用中用 `QXML` 替代了`HTML`。打开一个 `QXML` 文件示例:

```html
<view class="box">
  <view class="userinfo">
    <button qa:if="{{!hasUserInfo}}">获取头像昵称</button>
    <block qa:else>
      <image src="{{userInfo.avatarUrl}}" background-size="cover"></image>
      <text class="name">{{userInfo.nickName}}</text>
    </block>
  </view>
  <view class="motto">
    <text class="text">{{motto}}</text>
  </view>
</view>
```

`QXML` 的写法和 `HTML` 非常相似，由标签、属性等等构成。两者的差异主要下面几个：

1. 标签不同

   快应用中封装了一套不同于网页的基本组件。提供了地图、视频、音频等组件能力。体现在 `QXML` 中就是不同于 `HTML` 的标签名，如 `view`, `button`, `text`, `map`, `picker` 等。

   更多详细的组件讲述参考下个章节 [快应用的能力](./framework.html)

2. `QXML` 带有指令系统和表达式绑定

   详细的文档可以参考 [QXML](/reference/qxml/)

3. `QXML` 不允许加载 js

## 样式

和网页的 `CSS` 大体一致，也有一些扩充和修改。

1. 支持新的尺寸单位 rpx

2. 全局的样式和局部样式。 `app.css` 作为全局样式，会作用于当前快应用的所有页面，局部页面样式 `page.css` 仅对当前页面生效，自定义组件 css 仅对该组件生效。

## JS 逻辑交互

快应用采用 JS 来编写逻辑交互。用于响应用户操作、获取网络数据、处理逻辑计算等等。

举一个响应点击事件的例子。

```html
<view>
  <view>{{ message }}</view>
  <button bindtap="handleClick">按钮</button>
</view>
```

我们希望点击 `button` 按钮的时候，界面上 `message` 的值显示成 `"Hello QuickApp"`，我们可以在 JS 文件里边声明 `handleClick` 方法来响应这次点击操作：

```js
Page({
  data: {
    message: 'Hello World
  },
  handleClick: function() {
    this.setData({ message: "Hello QuickApp" })
  }
})

```

JS 文件和 QXML 文件通过 `bindtap="handleClick"` 这个属性声明产生关联。详情可以参考 [QXML - 事件](./../view/event.html) 。

另外，不同于浏览器端的 JS ， 快应用提供了更为丰富的 JS API，用于获取用户信息、本地存储、支付等等。详情可以参考 [快应用的 API](../app-service/api.html) 。
