# text

文本。

| 属性       | 类型    | 默认值 | 必填 | 说明         |
| ---------- | ------- | ------ | ---- | ------------ |
| selectable | boolean | false  | 否   | 文本是否可选 |
| space      | string  |        | 否   | 显示连续空格 |
| decode     | boolean | false  | 否   | 是否解码     |

**space 的合法值**

| 值   | 说明                   |
| ---- | ---------------------- |
| ensp | 中文字符空格一半大小   |
| emsp | 中文字符空格大小       |
| nbsp | 根据字体设置的空格大小 |

## Bug & Tip

::: warning

- decode 可以解析的有 `&nbsp;` `&lt;` `&gt;` `&amp;` `&apos;` `&ensp;` `&emsp;`
- 各个操作系统的空格标准并不一致。
- text 组件内只支持 text 嵌套。
- 除了文本节点以外的其他节点都无法长按选中。

:::

## 示例代码

```html
<!-- qxml -->
<view class="btn-area">
  <view class="body-view">
    <text>{{text}}</text>
    <button bindtap="add">add line</button>
    <button bindtap="remove">remove line</button>
  </view>
</view>
```

```js
// js
var initData = 'this is first line\nthis is second line'
var extraLine = []
Page({
  data: {
    text: initData
  },
  add: function(e) {
    extraLine.push('other line')
    this.setData({
      text: initData + '\n' + extraLine.join('\n')
    })
  },
  remove: function(e) {
    if (extraLine.length > 0) {
      extraLine.pop()
      this.setData({
        text: initData + '\n' + extraLine.join('\n')
      })
    }
  }
})
```

![](~@assets/text.png)
