# scroll-view

可以滚动的视图区域。当使用竖向滚动时，需要给[scroll-view](scroll-view.html)一个固定高度，通过 CSS 设置 height。

| 属性 | 类型 | <div style="width: 50px">默认值 </div> | <div style="width: 50px">必填 </div> | 说明 |
| --- | --- | --- | --- | --- |
| scroll-x | boolean | false | 否 | 允许横向滚动 |
| scroll-y | boolean | false | 否 | 允许纵向滚动 |
| upper-threshold | number/string | 50 | 否 | 距顶部/左边多远时，触发 scrolltoupper 事件 |
| lower-threshold | number/string | 50 | 否 | 距底部/右边多远时，触发 scrolltolower 事件 |
| scroll-top | number/string |  | 否 | 设置竖向滚动条位置 |
| scroll-left | number/string |  | 否 | 设置横向滚动条位置 |
| scroll-into-view | string |  | 否 | 值应为某子元素 id（id 不能以数字开头）。设置哪个方向可滚动，则在哪个方向滚动到该元素 |
| scroll-with-animation | boolean | false | 否 | 在设置滚动条位置时使用动画过渡 |
| bindscrolltoupper | eventhandle |  | 否 | 滚动到顶部/左边时触发 |
| bindscrolltolower | eventhandle |  | 否 | 滚动到底部/右边时触发 |
| bindscroll | eventhandle |  | 否 | 滚动时触发，event.detail = {scrollLeft, scrollTop, scrollHeight, scrollWidth, deltaX, deltaY} |

## Bug & Tip

::: warning

- `scroll-into-view` 的优先级高于 `scroll-top`
- 在滚动 `scroll-view` 时会阻止页面回弹，所以在 `scroll-view` 中滚动，是无法触发 `onPullDownRefresh`
- 若要使用下拉刷新，请使用页面的滚动，而不是 `scroll-view` ，这样也能通过点击顶部状态栏回到页面顶部

:::

## 示例代码

```html
<!-- qxml  -->
<view class="page-section">
  <view class="page-section-title">
    <text>Vertical Scroll\n纵向滚动</text>
  </view>
  <view class="page-section-spacing">
    <scroll-view
      scroll-y="true"
      style="height: 300rpx;"
      bindscrolltoupper="upper"
      bindscrolltolower="lower"
      bindscroll="scroll"
      scroll-into-view="{{toView}}"
      scroll-top="{{scrollTop}}"
      scroll-with-animation
    >
      <view id="demo1" class="scroll-view-item demo-text-1"></view>
      <view id="demo2" class="scroll-view-item demo-text-2"></view>
      <view id="demo3" class="scroll-view-item demo-text-3"></view>
    </scroll-view>
  </view>
  <view class="btn-wrap">
    <button size="mini" bindtap="tap">next</button>
    <button size="mini" bindtap="tapMoveTop">scrollToTop</button>
  </view>
</view>
<view class="page-section">
  <view class="page-section-title">
    <text>Horizontal Scroll\n横向滚动</text>
  </view>
  <view class="page-section-spacing">
    <scroll-view class="scroll-view_H" scroll-x="true" bindscroll="scroll" style="width: 100%">
      <view id="demo4" class="scroll-view-item_H demo-text-1"></view>
      <view id="demo5" class="scroll-view-item_H demo-text-2"></view>
      <view id="demo6" class="scroll-view-item_H demo-text-3"></view>
    </scroll-view>
  </view>
</view>
```

```js
// js
const order = ['demo1', 'demo2', 'demo3', 'demo1']

Page({
  data: {
    toView: 'demo3',
    scrollTop: null
  },

  tap() {
    for (let i = 0; i < order.length; ++i) {
      if (order[i] === this.data.toView) {
        this.setData({
          toView: order[i + 1],
          scrollTop: 0
        })
        break
      }
    }
  },

  tapMoveTop() {
    this.setData({
      scrollTop: 0,
      toView: 'demo1'
    })
  }
})
```

```css
/*  css */
.page-section-spacing {
  margin-top: 60rpx;
}
.scroll-view_H {
  white-space: nowrap;
}
.scroll-view-item {
  height: 300rpx;
}
.scroll-view-item_H {
  display: inline-block;
  width: 100%;
  height: 300rpx;
}
```
