# picker-view

嵌入页面的滚动选择器。其中只可放置 [picker-view-column](picker-view-column.html)组件，其它节点不会显示。

| 属性 | 类型 | <div style="width: 50px">默认值 </div> | <div style="width: 50px">必填 </div> | 说明 |
| --- | --- | --- | --- | --- |
| value | Array.\<number> |  | 否 | 数组中的数字依次表示 picker-view 内的 picker-view-column 的选择项（下标从 0 开始），数字大于 picker-view-column 可选项长度时，选择最后一项。 |
| indicator-style | string |  | 否 | 设置选择器中间选中框的样式 |
| indicator-class | string |  | 否 | 设置选择器中间选中框的类名 |
| mask-style | string |  | 否 | 设置蒙层的样式 |
| mask-class | string |  | 否 | 设置蒙层的类名 |
| bindchange | eventhandle |  | 否 | 滚动选择时触发 change 事件，event.detail = {value}；value 为数组，表示 picker-view 内的 picker-view-column 当前选择的是第几项（下标从 0 开始） |
| bindpickstart | eventhandle |  | 否 | 当滚动选择开始时候触发的事件回调 |
| bindpickend | eventhandle |  | 否 | 当滚动选择结束时候触发的事件回调 |

## 示例代码

```html
<view>
  <view>{{year}}年{{month}}月{{day}}日</view>
  <picker-view
    indicator-style="height: 50px;"
    style="width: 100%; height: 300px;"
    value="{{value}}"
    bindchange="bindChange"
  >
    <picker-view-column>
      <view qa:for="{{years}}" style="line-height: 50px">{{item}}年</view>
    </picker-view-column>
    <picker-view-column>
      <view qa:for="{{months}}" style="line-height: 50px">{{item}}月</view>
    </picker-view-column>
    <picker-view-column>
      <view qa:for="{{days}}" style="line-height: 50px">{{item}}日</view>
    </picker-view-column>
  </picker-view>
</view>
```

```js
const date = new Date()
const years = []
const months = []
const days = []

for (let i = 1990; i <= date.getFullYear(); i++) {
  years.push(i)
}

for (let i = 1; i <= 12; i++) {
  months.push(i)
}

for (let i = 1; i <= 31; i++) {
  days.push(i)
}

Page({
  data: {
    years: years,
    year: date.getFullYear(),
    months: months,
    month: 2,
    days: days,
    day: 2,
    value: [9999, 1, 1]
  },
  bindChange: function(e) {
    const val = e.detail.value
    this.setData({
      year: this.data.years[val[0]],
      month: this.data.months[val[1]],
      day: this.data.days[val[2]]
    })
  }
})
```

![](~@assets/picker-view.png)
