# navigator

页面链接。

| 属性 | 类型 | 默认值 | <div style="width: 50px">必填 </div> | 说明 |
| --- | --- | --- | --- | --- |
| target | string | self | 否 | 在哪个目标上发生跳转，默认当前快应用 |
| url | string |  | 否 | 当前快应用内的跳转链接 |
| open-type | string | navigate | 否 | 跳转方式 |
| app-id | string |  | 否 | 当`target="quickApp"`时有效，要打开的快应用 appId |
| path | string |  | 否 | 当`target="quickApp"`时有效，打开的页面路径，如果为空则打开首页 |
| extra-data | object |  | 否 | 当`target="quickApp"`时有效，需要传递给目标快应用的数据，目标快应用可在 `App.onLaunch()`，`App.onShow()` 中获取到这份数据。[详情](./../framework/app-service/app.html) |
| hover-class | string | navigator-hover | 否 | 指定点击时的样式类，当`hover-class="none"`时，没有点击态效果 |
| hover-stop-propagation | boolean | false | 否 | 指定是否阻止本节点的祖先节点出现点击态 |
| hover-start-time | number | 50 | 否 | 按住后多久出现点击态，单位毫秒 |
| hover-stay-time | number | 600 | 否 | 手指松开后点击态保留时间，单位毫秒 |
| bindsuccess | string |  | 否 | 当`target="quickApp"`时有效，跳转快应用成功 |
| bindfail | string |  | 否 | 当`target="quickApp"`时有效，跳转快应用失败 |
| bindcomplete | string |  | 否 | 当`target="quickApp"`时有效，跳转快应用完成 |

**target 的合法值**

| 值       | 说明       |
| -------- | ---------- |
| self     | 当前快应用 |
| quickApp | 其它快应用 |

**open-type 的合法值**

| 值 | 说明 |
| --- | --- |
| navigate | 对应 [qa.navigateTo](../api/route/qa.navigateTo.html) 或 [qa.navigateToQuickapp](../api/open-api/quickapp-navigate/qa.navigateToQuickapp.html) 的功能 |
| redirect | 对应 [qa.redirectTo](../api/route/qa.redirectTo.html) 的功能 |
| switchTab | 对应 [qa.switchTab](../api/route/qa.switchTab.html) 的功能 |
| reLaunch | 对应 [qa.reLaunch](../api/route/qa.reLaunch.html) 的功能 |
| navigateBack | 对应 [qa.navigateBack](../api/route/qa.navigateBack.html) 的功能 |
| exit | 退出快应用，`target="quickApp"`时生效 |

#### 使用限制

::: danger

- 在跳转至其他快应用前，将统一增加弹窗，询问是否跳转，用户确认后才可以跳转其他快应用。如果用户点击取消，则回调 `fail cancel`。

:::

<!-- #### 关于调试

* 在开发者工具上调用此 API 并不会真实的跳转到另外的快应用，但是开发者工具会校验本次调用跳转是否成功。[详情](../devtools/different.html#%E8%B7%B3%E8%BD%AC%E5%B0%8F%E7%A8%8B%E5%BA%8F%E8%B0%83%E8%AF%95%E6%94%AF%E6%8C%81)
* 开发者工具上支持被跳转的快应用处理接收参数的调试。[详情](../devtools/different.html#%E8%B7%B3%E8%BD%AC%E5%B0%8F%E7%A8%8B%E5%BA%8F%E8%B0%83%E8%AF%95%E6%94%AF%E6%8C%81) -->

## Bug & Tip

::: warning

- `navigator-hover` 默认为 `{background-color: rgba(0, 0, 0, 0.1); opacity: 0.7;}`, [navigator](navigator.html) 的子节点背景色应为透明色

:::

## 示例代码

```css
.navigator-hover {
  color: blue;
}
.other-navigator-hover {
  color: red;
}
```

```html
<!-- sample.qxml -->
<view class="btn-area">
  <navigator url="/page/navigate/navigate?title=navigate" hover-class="navigator-hover">跳转到新页面</navigator>
  <navigator
    url="../../redirect/redirect/redirect?title=redirect"
    open-type="redirect"
    hover-class="other-navigator-hover"
    >在当前页打开</navigator
  >
  <navigator url="/page/index/index" open-type="switchTab" hover-class="other-navigator-hover">切换 Tab</navigator>
  <navigator target="quickApp" open-type="navigate" app-id="" path="" extra-data="" version="release"
    >打开绑定的快应用</navigator
  >
</view>
```

```html
<!-- navigator.qxml -->
<view style="text-align:center"> {{title}} </view>
<view> 点击左上角返回回到之前页面 </view>
```

```html
<!-- redirect.qxml -->
<view style="text-align:center"> {{title}} </view>
<view> 点击左上角返回回到上级页面 </view>
```

```js
Page({
  onLoad: function(options) {
    this.setData({
      title: options.title
    })
  }
})
```
