# checkbox

多选项目。

| 属性 | 类型 | <div style="width: 50px">默认值 </div> | <div style="width: 50px">必填 </div> | 说明 |
| --- | --- | --- | --- | --- |
| value | string |  | 否 | [checkbox](checkbox.html)标识，选中时触发[checkbox-group](checkbox-group.html)的 change 事件，并携带 [checkbox](checkbox.html) 的 value |
| disabled | boolean | false | 否 | 是否禁用 |
| checked | boolean | false | 否 | 当前是否选中，可用来设置默认选中 |
| color | string | #09BB07 | 否 | checkbox 的颜色，同 css 的 color |

## 示例代码

```html
<checkbox-group bindchange="checkboxChange">
  <label class="checkbox" qa:for="{{items}}">
    <checkbox value="{{item.name}}" checked="{{item.checked}}" />{{item.value}}
  </label>
</checkbox-group>
```

```js
Page({
  data: {
    items: [
      { name: 'USA', value: '美国' },
      { name: 'CHN', value: '中国', checked: 'true' },
      { name: 'BRA', value: '巴西' },
      { name: 'JPN', value: '日本' },
      { name: 'ENG', value: '英国' },
      { name: 'TUR', value: '法国' }
    ]
  },
  checkboxChange: function(e) {
    console.log('checkbox发生change事件，携带value值为：', e.detail.value)
  }
})
```

![](data:image/png;base64,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)
