# button

按钮。

| 属性 | 类型 | <div style="width: 50px">默认值 </div> | <div style="width: 50px">必填 </div> | 说明 |
| --- | --- | --- | --- | --- |
| size | string | default | 否 | 按钮的大小 |
| type | string | default | 否 | 按钮的样式类型 |
| plain | boolean | false | 否 | 按钮是否镂空，背景色透明 |
| disabled | boolean | false | 否 | 是否禁用 |
| loading | boolean | false | 否 | 名称前是否带 loading 图标 |
| form-type | string |  | 否 | 用于 [form](form.html) 组件，点击分别会触发 [form](form.html) 组件的 submit/reset 事件 |
| hover-class | string | button-hover | 否 | 指定按钮按下去的样式类。当 `hover-class="none"` 时，没有 hover 态效果 |
| hover-stop-propagation | boolean | false | 否 | 指定是否阻止本节点的祖先节点出现 hover 态 |
| hover-start-time | number | 20 | 否 | 按住后多久出现 hover 态，单位毫秒 |
| hover-stay-time | number | 70 | 否 | 手指松开后 hover 态保留时间，单位毫秒 |

**size 的合法值**

| 值      | 说明     |
| ------- | -------- |
| default | 默认大小 |
| mini    | 小尺寸   |

**type 的合法值**

| 值      | 说明 |
| ------- | ---- |
| primary | 绿色 |
| default | 白色 |
| warn    | 红色 |

**form-type 的合法值**

| 值     | 说明     |
| ------ | -------- |
| submit | 提交表单 |
| reset  | 重置表单 |

## Bug & Tip

::: warning `button-hover` 默认为`{background-color: rgba(0, 0, 0, 0.1); opacity: 0.7;}` :::

## 示例代码

```html
<!-- qxml -->
<view class="page-body" style="height: 100%">
  <view class="btn-area" id="buttonContainer">
    <button type="primary">页面主操作 Normal</button>
    <button type="primary" loading="true">页面主操作 Loading</button>
    <button type="primary" disabled="true">页面主操作 Disabled</button>

    <button type="default">页面次要操作 Normal</button>
    <button type="default" disabled="true">页面次要操作 Disabled</button>

    <button type="warn">警告类操作 Normal</button>
    <button type="warn" disabled="true">警告类操作 Disabled</button>

    <view class="button-sp-area">
      <button type="primary" plain="true">按钮</button>
      <button type="primary" disabled="true" plain="true">不可点击的按钮</button>

      <button type="default" plain="true">按钮</button>
      <button type="default" disabled="true" plain="true">按钮</button>

      <button class="mini-btn" type="primary" size="mini">按钮</button>
      <button class="mini-btn" type="default" size="mini">按钮</button>
      <button class="mini-btn" type="warn" size="mini">按钮</button>
    </view>
  </view>
</view>
```

```js
// js
const types = ['default', 'primary', 'warn']
const pageObject = {
  data: {
    defaultSize: 'default',
    primarySize: 'default',
    warnSize: 'default',
    disabled: false,
    plain: false,
    loading: false
  },

  setDisabled() {
    this.setData({
      disabled: !this.data.disabled
    })
  },

  setPlain() {
    this.setData({
      plain: !this.data.plain
    })
  },

  setLoading() {
    this.setData({
      loading: !this.data.loading
    })
  }
}

for (let i = 0; i < types.length; ++i) {
  ;(function(type) {
    pageObject[type] = function() {
      const key = type + 'Size'
      const changedData = {}
      changedData[key] = this.data[key] === 'default' ? 'mini' : 'default'
      this.setData(changedData)
    }
  })(types[i])
}

Page(pageObject)
```

```css
/* css */
button {
  margin-top: 30rpx;
  margin-bottom: 30rpx;
}
.button-sp-area {
  margin: 0 auto;
  width: 60%;
}
.mini-btn {
  margin-right: 10rpx;
}
```

![](~@assets/button.png)
