# qa.getStorage(Object object)

从本地缓存中获取指定 key 的内容，异步接口

## 参数

### Object object

| 属性 | 类型 | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| key | string |  | 是 | 指定的 key |
| success | function |  | 否 | 接口调用成功的回调函数 |
| fail | function |  | 否 | 接口调用失败的回调函数 |
| complete | function |  | 否 | 接口调用结束的回调函数（调用成功、失败都会执行） |

#### object.success 回调函数

##### 参数

###### Object res

| 属性 | 类型 | 说明           |
| ---- | ---- | -------------- |
| data | any  | key 对应的内容 |

## 示例代码

```js
qa.getStorage({
  key: 'key',
  success(res) {
    console.log(res.data)
  }
})
```

```js
try {
  var value = qa.getStorageSync('key')
  if (value) {
    // Do something with return value
  }
} catch (e) {
  // Do something when catch error
}
```
