# UploadTask

用于监听上传进度进度变化的事件和取消上传的实例

## 方法

### [UploadTask.abort()](UploadTask.abort.html)

中断该上传任务

### [UploadTask.onProgressUpdate(function callback)](./UploadTask.onProgressUpdate.html)

订阅**上传进度变化事件**回调

### [UploadTask.offProgressUpdate(function callback)](./UploadTask.offProgressUpdate.html)

取消订阅**上传进度变化事件**

## 示例代码

```js
const uploadTask = qa.uploadFile({
  url: 'http://example.quickapp.cn/upload', //仅为示例，非真实的接口地址
  filePath: tempFilePaths[0],
  name: 'file',
  formData: {
      user: 'test',
      user2: 'test2'
  },
  success(res) {
    const data = res.data
    //do something
  }
})

uploadTask.onProgressUpdate(res => {
  console.log('上传进度', res.progress)
  console.log('已经上传的数据长度', res.totalBytesSent)
  console.log('预期需要上传的数据总长度', res.totalBytesExpectedToSend)
})

uploadTask.abort() // 取消上传任务
```
