# [DownloadTask](DownloadTask.html) qa.downloadFile(Object object)

下载文件资源到本地的接口。

调用该接口会返回一个 [DownloadTask](DownloadTask.html) 实例，用于监听其下载进度变化，以及取消下载

注意：请在服务端响应的 header 中指定合理的 `Content-Type` 字段，以保证客户端正确处理文件类型。

## 参数

### Object object

| 属性 | 类型 | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| url | string |  | 是 | 下载资源的 url |  |
| header | Object |  | 否 | HTTP 请求的 Header，不支持 Referer |  |
| filePath | string |  | 否 | 指定文件下载后存储的路径 |  |
| success | function |  | 否 | 接口调用成功的回调函数 |  |
| fail | function |  | 否 | 接口调用失败的回调函数 |  |
| complete | function |  | 否 | 接口调用结束的回调函数（调用成功、失败都会执行） |  |

#### object.success 回调函数

##### 参数

###### Object res

| 属性         | 类型   | 说明                                                                                     |
| ------------ | ------ | ---------------------------------------------------------------------------------------- |
| tempFilePath | string | 下载文件的临时文件路径。没传入 filePath 指定文件存储路径时会返回，下载后的文件会存储到一个临时文件 |
| filePath     | string | 下载文件的文件路径。传入 filePath 时会返回，跟传入的 filePath 一致                             |
| statusCode   | number | 状态码，下载成功时为 200，非 HTTP 状态码                                                 |

## 返回值

### [DownloadTask](DownloadTask.html)

下载任务实例，可以监听其下载进度变化，以及取消下载

## 示例代码

```js
qa.downloadFile({
  url: 'https://example.com/audio/123', //仅为示例，并非真实的资源
  success(res) {
    if (res.statusCode === 200) {
      qa.playVoice({
        filePath: res.tempFilePath
      })
    }
  }
})
```
