# VideoContext

VideoContext 实例，可通过 [qa.createVideoContext](qa.createVideoContext.html) 获取。

[VideoContext](VideoContext.html) 通过 `id` 跟一个 [video](../../../component/video.html) 组件绑定，操作对应的 [video](../../../component/video.html) 组件。

## 方法

### [VideoContext.play()](VideoContext.play.html)

播放视频

### [VideoContext.pause()](VideoContext.pause.html)

暂停视频

### [VideoContext.stop()](VideoContext.stop.html)

停止视频

### [VideoContext.seek(number position)](VideoContext.seek.html)

跳转到指定位置

### [VideoContext.requestFullScreen(Object object)](VideoContext.requestFullScreen.html)

进入全屏

### [VideoContext.exitFullScreen()](VideoContext.exitFullScreen.html)

退出全屏

## 示例代码

```html
<view class="section tc">
  <video
    id="myVideo"
    src="http://qjsnsdy.tc.qq.com/105/20210/snsdyvideodownload?filekey=30280201010421301f0201690402534804102ca905ce620b1241b726bc41dcff44e00204012882540400&bizid=1023&hy=SH&fileparam=302c020101042530230204136ffd93020457e3c4ff02024ef202031e8d7f02030f42400204045a320a0201000400"
    danmu-btn
    controls
  ></video>
  <view class="btn-area">
    <input bindblur="bindInputBlur" />
  </view>
</view>
```

```js
function getRandomColor() {
  let rgb = []
  for (let i = 0; i < 3; ++i) {
    let color = Math.floor(Math.random() * 256).toString(16)
    color = color.length == 1 ? '0' + color : color
    rgb.push(color)
  }
  return '#' + rgb.join('')
}

Page({
  onReady(res) {
    this.videoContext = qa.createVideoContext('myVideo')
  },
  inputValue: '',
  bindInputBlur(e) {
    this.inputValue = e.detail.value
  }
})
```
