# MapContext

MapContext 实例，可通过 [qa.createMapContext](qa.createMapContext.html) 获取。

[MapContext](MapContext.html) 通过 `id` 跟一个 [map](../../../component/map.html) 组件绑定，操作对应的 [map](../../../component/map.html) 组件。

## 方法

### [MapContext.getCenterLocation()](MapContext.getCenterLocation.html)

获取当前地图中心的经纬度。返回的是 gcj02 坐标系，可以用于 [qa.openLocation()](../../location/qa.openLocation.html)

### [MapContext.moveToLocation()](MapContext.moveToLocation.html)

将地图中心移动到当前定位点。需要配合 map 组件的 show-location 使用

### [MapContext.translateMarker(Object object)](MapContext.translateMarker.html)

平移 marker，带动画

### [MapContext.includePoints(Object object)](MapContext.includePoints.html)

缩放视野展示所有经纬度

### [MapContext.getRegion()](MapContext.getRegion.html)

获取当前地图的视野范围

### [MapContext.getScale()](MapContext.getScale.html)

获取当前地图的缩放级别

## 示例代码

```html
<!-- map.qxml -->
<map id="myMap" show-location />

<button type="primary" bindtap="getCenterLocation">获取位置</button>
<button type="primary" bindtap="moveToLocation">移动位置</button>
<button type="primary" bindtap="translateMarker">移动标注</button>
<button type="primary" bindtap="includePoints">缩放视野展示所有经纬度</button>
```

```js
// map.js
Page({
  onReady: function(e) {
    // 使用 qa.createMapContext 获取 map 上下文
    this.mapCtx = qa.createMapContext('myMap')
  },
  getCenterLocation: function() {
    this.mapCtx.getCenterLocation({
      success: function(res) {
        console.log(res.longitude)
        console.log(res.latitude)
      }
    })
  },
  moveToLocation: function() {
    this.mapCtx.moveToLocation()
  },
  translateMarker: function() {
    this.mapCtx.translateMarker({
      markerId: 0,
      autoRotate: true,
      duration: 1000,
      destination: {
        latitude: 23.10229,
        longitude: 113.3345211
      },
      animationEnd() {
        console.log('animation end')
      }
    })
  },
  includePoints: function() {
    this.mapCtx.includePoints({
      padding: [10],
      points: [
        {
          latitude: 23.10229,
          longitude: 113.3345211
        },
        {
          latitude: 23.00229,
          longitude: 113.3345211
        }
      ]
    })
  }
})
```
