# CanvasContext.stroke()

画出当前路径的边框。默认颜色色为黑色。

## 示例代码

```js
const ctx = qa.createCanvasContext('myCanvas')
ctx.moveTo(10, 10)
ctx.lineTo(100, 10)
ctx.lineTo(100, 100)
ctx.stroke()
ctx.draw()
```

![](data:image/png;base64,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)

stroke() 描绘的的路径是从 beginPath() 开始计算，但是不会将 strokeRect() 包含进去。

```js
const ctx = qa.createCanvasContext('myCanvas')
// begin path
ctx.rect(10, 10, 100, 30)
ctx.setStrokeStyle('yellow')
ctx.stroke()

// begin another path
ctx.beginPath()
ctx.rect(10, 40, 100, 30)

// only stoke this rect, not in current path
ctx.setStrokeStyle('blue')
ctx.strokeRect(10, 70, 100, 30)

ctx.rect(10, 100, 100, 30)

// it will stroke current path
ctx.setStrokeStyle('red')
ctx.stroke()
ctx.draw()
```

![](data:image/png;base64,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)
