# CanvasContext.drawImage(string imageResource, number sx, number sy, number sWidth, number sHeight, number dx, number dy, number dWidth, number dHeight)

绘制图像到画布

## 参数

### string imageResource

所要绘制的图片资源

### number sx

源图像的矩形选择框的左上角 x 坐标

### number sy

源图像的矩形选择框的左上角 y 坐标

### number sWidth

源图像的矩形选择框的宽度

### number sHeight

源图像的矩形选择框的高度

### number dx

图像的左上角在目标 canvas 上 x 轴的位置

### number dy

图像的左上角在目标 canvas 上 y 轴的位置

### number dWidth

在目标画布上绘制图像的宽度，允许对绘制的图像进行缩放

### number dHeight

在目标画布上绘制图像的高度，允许对绘制的图像进行缩放

## 示例代码

有三个版本的写法：

- drawImage(imageResource, dx, dy)
- drawImage(imageResource, dx, dy, dWidth, dHeight)
- drawImage(imageResource, sx, sy, sWidth, sHeight, dx, dy, dWidth, dHeight)

```js
const ctx = qa.createCanvasContext('myCanvas')

qa.chooseImage({
  success: function(res) {
    ctx.drawImage(res.tempFilePaths[0], 0, 0, 150, 100)
    ctx.draw()
  }
})
```
