# Object qa.getSystemInfoSync()

[qa.getSystemInfo](qa.getSystemInfo.html) 的同步版本接口

## 返回值

### Object res

| 属性                   | 类型    | 说明                        |
| ---------------------- | ------- | --------------------------- |
| brand                  | string  | 手机品牌                    |  |
| model                  | string  | 手机型号                    |  |
| pixelRatio             | number  | 手机像素比                  |  |
| screenWidth            | number  | 手机屏幕宽度，单位 px           |  |
| screenHeight           | number  | 手机屏幕高度，单位 px           |  |
| windowWidth            | number  | 手机可使用窗口宽度，单位 px     |  |
| windowHeight           | number  | 手机可使用窗口高度，单位 px     |  |
| statusBarHeight        | number  | 手机状态栏的高度，单位 px       |  |
| language               | string  | 当前手机系统的语言                |  |
| version                | string  | 快应用引擎版本号，字符串类型，比如"1054"        |  |
| SDKVersion             | string  | 快应用引擎版本号, number类型，比如1054 |  |
| system                 | string  | 手机操作系统及版本              |  |
| platform               | string  | 手机平台，比如"android"                  |  |
| fontSizeSetting        | number  | 用户设置字体大小（单位 px）     |  |
| cameraAuthorized       | boolean | 当前快应用是否获得摄像头权限       |  |
| locationAuthorized     | boolean | 当前快应用是否获得定位权限          |  |
| microphoneAuthorized   | boolean | 当前快应用是否获得麦克风权限        |  |
| bluetoothEnabled       | boolean | 手机蓝牙的系统权限开关              |  |
| locationEnabled        | boolean | 手机地理位置的系统开关          |  |
| wifiEnabled            | boolean | 手机Wi-Fi的系统开关            |  |

## 示例代码

```js
try {
  const res = qa.getSystemInfoSync()
  console.log(res.model)
  console.log(res.pixelRatio)
  console.log(res.windowWidth)
  console.log(res.windowHeight)
  console.log(res.language)
  console.log(res.version)
  console.log(res.platform)
} catch (e) {
  // Do something when catch error
}
```
